/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.jdbc;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.beam.it.common.utils.ResourceManagerUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Chars;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class JDBCResourceManagerUtils {
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_DATABASE_NAME_LENGTH = 30;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern ILLEGAL_DATABASE_NAME_CHARS = Pattern.compile("[^a-zA-Z0-9_$#]");
    private static final @UnknownKeyFor @NonNull @Initialized String REPLACE_DATABASE_NAME_CHAR = "_";
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_PASSWORD_LENGTH = 9;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_PASSWORD_LENGTH = 25;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_TABLE_ID_LENGTH = 1;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_TABLE_ID_LENGTH = 30;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern ILLEGAL_TABLE_CHARS = Pattern.compile("[/.]");
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSSSSS");
    public static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Character> ALLOWED_SPECIAL_CHARS = Chars.asList((char[])"~!@#$%^&*()_-+={}[]/<>,.?:|".toCharArray());

    private JDBCResourceManagerUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized String generateDatabaseName(@UnknownKeyFor @NonNull @Initialized String baseString) {
        baseString = Character.isLetter(baseString.charAt(0)) ? baseString : "d_" + baseString;
        return ResourceManagerUtils.generateResourceId((String)baseString, (Pattern)ILLEGAL_DATABASE_NAME_CHARS, (String)REPLACE_DATABASE_NAME_CHAR, (int)30, (DateTimeFormatter)TIME_FORMAT);
    }

    static @UnknownKeyFor @NonNull @Initialized String generateJdbcPassword() {
        int numLower = 2;
        int numUpper = 2;
        int numSpecial = 2;
        return ResourceManagerUtils.generatePassword((int)9, (int)25, (int)numLower, (int)numUpper, (int)numSpecial, ALLOWED_SPECIAL_CHARS);
    }

    static void checkValidTableName(@UnknownKeyFor @NonNull @Initialized String nameToCheck) {
        if (nameToCheck.length() < 1) {
            throw new IllegalArgumentException("Table name cannot be empty. ");
        }
        if (nameToCheck.length() > 30) {
            throw new IllegalArgumentException("Table name " + nameToCheck + " cannot be longer than " + 30 + " characters.");
        }
        if (ILLEGAL_TABLE_CHARS.matcher(nameToCheck).find()) {
            throw new IllegalArgumentException("Table name " + nameToCheck + " is not a valid name. Periods and forward slashes are not allowed.");
        }
    }
}

