/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import org.apache.beam.it.jdbc.AbstractJDBCResourceManager;
import org.apache.beam.it.jdbc.JDBCResourceManagerException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.utility.DockerImageName;

public class MSSQLResourceManager
extends AbstractJDBCResourceManager<DefaultMSSQLServerContainer<?>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MSSQLResourceManager.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_MSSQL_CONTAINER_NAME = "mcr.microsoft.com/azure-sql-edge";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_MSSQL_CONTAINER_TAG = "1.0.6";
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;

    private MSSQLResourceManager(@UnknownKeyFor @NonNull @Initialized Builder builder) {
        super(new DefaultMSSQLServerContainer(DockerImageName.parse((String)builder.containerImageName).withTag(builder.containerImageTag).asCompatibleSubstituteFor("mcr.microsoft.com/mssql/server"), builder.databaseName, builder.useStaticContainer), builder);
        this.createDatabase(builder.databaseName);
    }

    @VisibleForTesting
    <T extends DefaultMSSQLServerContainer<T>> MSSQLResourceManager(T container, @UnknownKeyFor @NonNull @Initialized Builder builder) {
        super(container, builder);
        this.initialized = true;
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized String testId) {
        return new Builder(testId);
    }

    private synchronized void createDatabase(@UnknownKeyFor @NonNull @Initialized String databaseName) {
        LOG.info("Creating database using databaseName '{}'.", (Object)databaseName);
        StringBuilder sql = new StringBuilder();
        try (Connection con = this.driver.getConnection(this.getUri(), this.username, this.password);){
            Statement stmt = con.createStatement();
            sql.append("CREATE DATABASE ").append(databaseName);
            stmt.executeUpdate(sql.toString());
            stmt.close();
        }
        catch (Exception e) {
            throw new JDBCResourceManagerException("Error creating database with SQL statement: " + sql, e);
        }
        this.initialized = true;
        LOG.info("Successfully created database {}.{}", (Object)databaseName, (Object)databaseName);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized String getUri() {
        return String.format("jdbc:%s://%s:%d%s%s", this.getJDBCPrefix(), this.getHost(), this.getPort(this.getJDBCPort()), this.initialized ? ";DatabaseName=" + this.databaseName : "", ";encrypt=true;trustServerCertificate=true;");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getJDBCPrefix() {
        return "sqlserver";
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized int getJDBCPort() {
        return DefaultMSSQLServerContainer.MS_SQL_SERVER_PORT;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getFirstRow(@UnknownKeyFor @NonNull @Initialized String tableName) {
        return "SELECT TOP 1 * FROM " + tableName;
    }

    static final class DefaultMSSQLServerContainer<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized DefaultMSSQLServerContainer<T>>
    extends MSSQLServerContainer<T> {
        private final @UnknownKeyFor @NonNull @Initialized String databaseName;
        private final @UnknownKeyFor @NonNull @Initialized boolean usingStaticDatabase;

        DefaultMSSQLServerContainer(@UnknownKeyFor @NonNull @Initialized DockerImageName dockerImageName, @UnknownKeyFor @NonNull @Initialized String databaseName, @UnknownKeyFor @NonNull @Initialized boolean usingStaticDatabase) {
            super(dockerImageName);
            this.addEnv("ACCEPT_EULA", "Y");
            this.databaseName = databaseName;
            this.usingStaticDatabase = usingStaticDatabase;
        }

        public T withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            if (!username.equals("root") && !this.usingStaticDatabase) {
                throw new UnsupportedOperationException("The username cannot be overridden to " + username);
            }
            return (T)((Object)((DefaultMSSQLServerContainer)this.self()));
        }

        public T withDatabaseName(@UnknownKeyFor @NonNull @Initialized String dbName) {
            return (T)((Object)((DefaultMSSQLServerContainer)this.self()));
        }

        public @UnknownKeyFor @NonNull @Initialized String getDatabaseName() {
            return this.databaseName;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
            return super.equals(o);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return super.hashCode();
        }
    }

    public static final class Builder
    extends AbstractJDBCResourceManager.Builder<DefaultMSSQLServerContainer<?>> {
        public Builder(@UnknownKeyFor @NonNull @Initialized String testId) {
            super(testId, MSSQLResourceManager.DEFAULT_MSSQL_CONTAINER_NAME, MSSQLResourceManager.DEFAULT_MSSQL_CONTAINER_TAG);
        }

        public @UnknownKeyFor @NonNull @Initialized MSSQLResourceManager build() {
            return new MSSQLResourceManager(this);
        }
    }
}

