/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.jdbc;

import org.apache.beam.it.jdbc.AbstractJDBCResourceManager;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleResourceManager
extends AbstractJDBCResourceManager<OracleContainer> {
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ORACLE_CONTAINER_NAME = "gvenzl/oracle-xe";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ORACLE_CONTAINER_TAG = "21-slim-faststart";
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_ORACLE_INTERNAL_PORT = 1521;
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ORACLE_USERNAME = "testUser";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ORACLE_PASSWORD = "testPassword";

    private OracleResourceManager(@UnknownKeyFor @NonNull @Initialized Builder builder) {
        this(new OracleContainer(DockerImageName.parse((String)builder.containerImageName).withTag(builder.containerImageTag)), builder);
    }

    @VisibleForTesting
    OracleResourceManager(@UnknownKeyFor @NonNull @Initialized OracleContainer container, @UnknownKeyFor @NonNull @Initialized Builder builder) {
        super(container, builder);
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized String testId) {
        return new Builder(testId);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized int getJDBCPort() {
        return 1521;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getJDBCPrefix() {
        return "oracle";
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized String getUri() {
        return String.format("jdbc:%s:thin:@%s:%d/%s", this.getJDBCPrefix(), this.getHost(), this.getPort(this.getJDBCPort()), this.getDatabaseName());
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getFirstRow(@UnknownKeyFor @NonNull @Initialized String tableName) {
        return "SELECT * FROM " + tableName + " WHERE ROWNUM <= 1";
    }

    public static final class Builder
    extends AbstractJDBCResourceManager.Builder<OracleContainer> {
        public Builder(@UnknownKeyFor @NonNull @Initialized String testId) {
            super(testId, OracleResourceManager.DEFAULT_ORACLE_CONTAINER_NAME, OracleResourceManager.DEFAULT_ORACLE_CONTAINER_TAG);
            this.username = OracleResourceManager.DEFAULT_ORACLE_USERNAME;
            this.password = OracleResourceManager.DEFAULT_ORACLE_PASSWORD;
        }

        public @UnknownKeyFor @NonNull @Initialized OracleResourceManager build() {
            return new OracleResourceManager(this);
        }
    }
}

