/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.jdbc;

import org.apache.beam.it.jdbc.AbstractJDBCResourceManager;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresResourceManager
extends AbstractJDBCResourceManager<PostgreSQLContainer<?>> {
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_POSTGRES_CONTAINER_NAME = "postgres";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_POSTGRES_CONTAINER_TAG = "15.1";

    @VisibleForTesting
    PostgresResourceManager(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PostgreSQLContainer<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> container, @UnknownKeyFor @NonNull @Initialized Builder builder) {
        super(container, builder);
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized String testId) {
        return new Builder(testId);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized int getJDBCPort() {
        return PostgreSQLContainer.POSTGRESQL_PORT;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getJDBCPrefix() {
        return "postgresql";
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized String getDockerImageName() {
        return "postgresql";
    }

    public static final class Builder
    extends AbstractJDBCResourceManager.Builder<PostgreSQLContainer<?>> {
        public Builder(@UnknownKeyFor @NonNull @Initialized String testId) {
            super(testId, PostgresResourceManager.DEFAULT_POSTGRES_CONTAINER_NAME, PostgresResourceManager.DEFAULT_POSTGRES_CONTAINER_TAG);
        }

        public @UnknownKeyFor @NonNull @Initialized PostgresResourceManager build() {
            PostgreSQLContainer container = new PostgreSQLContainer(DockerImageName.parse((String)this.containerImageName).withTag(this.containerImageTag));
            container.setCommand(new String[]{PostgresResourceManager.DEFAULT_POSTGRES_CONTAINER_NAME, "-c", "fsync=off", "-c", "max_connections=1000"});
            return new PostgresResourceManager(container, this);
        }
    }
}

