/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.splunk;

import java.time.Duration;
import java.util.Collections;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class SplunkContainer
extends GenericContainer<SplunkContainer> {
    private static final @UnknownKeyFor @NonNull @Initialized int SPLUNK_INTERNAL_PORT = 8000;
    private static final @UnknownKeyFor @NonNull @Initialized int SPLUNK_HEC_INTERNAL_PORT = 8088;
    private static final @UnknownKeyFor @NonNull @Initialized int SPLUNKD_INTERNAL_PORT = 8089;
    private static final @UnknownKeyFor @NonNull @Initialized DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"splunk/splunk");
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULTS_FILE_PATH = "/tmp/defaults/default.yml";

    public SplunkContainer(@NonNull @UnknownKeyFor @Initialized String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public SplunkContainer(@UnknownKeyFor @NonNull @Initialized DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8000, 8088, 8089});
        this.withEnv(Collections.singletonMap("SPLUNK_START_ARGS", "--accept-license"));
        this.waitingFor(Wait.forLogMessage((String)"(?i).*Ansible playbook complete.*", (int)1).withStartupTimeout(Duration.ofMinutes(3L)));
    }

    public @UnknownKeyFor @NonNull @Initialized SplunkContainer withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
        this.withEnv("SPLUNK_PASSWORD", password);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SplunkContainer withHecToken(@UnknownKeyFor @NonNull @Initialized String hecToken) {
        this.withEnv("SPLUNK_HEC_TOKEN", hecToken);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SplunkContainer withSplunkdSslDisabled() {
        this.withEnv("SPLUNKD_SSL_ENABLE", "false");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SplunkContainer withDefaultsFile(@UnknownKeyFor @NonNull @Initialized Transferable defaults) {
        this.withCopyToContainer(defaults, DEFAULTS_FILE_PATH);
        return this;
    }
}

