/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.splunk;

import com.splunk.Job;
import com.splunk.ResultsReaderXml;
import com.splunk.ServiceArgs;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.it.common.ResourceManager;
import org.apache.beam.it.splunk.SplunkClientFactory;
import org.apache.beam.it.splunk.SplunkContainer;
import org.apache.beam.it.splunk.SplunkResourceManagerException;
import org.apache.beam.it.splunk.SplunkResourceManagerUtils;
import org.apache.beam.it.testcontainers.TestContainerResourceManager;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.awaitility.Awaitility;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class SplunkResourceManager
extends TestContainerResourceManager<SplunkContainer>
implements ResourceManager {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SplunkResourceManager.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SPLUNK_CONTAINER_NAME = "splunk/splunk";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SPLUNK_CONTAINER_TAG = "8.2";
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_SPLUNK_HEC_INTERNAL_PORT = 8088;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_SPLUNKD_INTERNAL_PORT = 8089;
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SPLUNK_USERNAME = "admin";
    private final @UnknownKeyFor @NonNull @Initialized ServiceArgs loginArgs;
    private final @UnknownKeyFor @NonNull @Initialized int hecPort;
    private final @UnknownKeyFor @NonNull @Initialized String hecScheme;
    private final @UnknownKeyFor @NonNull @Initialized String hecToken;
    private final @UnknownKeyFor @NonNull @Initialized SplunkClientFactory clientFactory;

    private SplunkResourceManager(@UnknownKeyFor @NonNull @Initialized Builder builder) {
        this(new SplunkClientFactory(), new SplunkContainer(DockerImageName.parse((String)builder.containerImageName).withTag(builder.containerImageTag)).withSplunkdSslDisabled(), builder);
    }

    @VisibleForTesting
    SplunkResourceManager(@UnknownKeyFor @NonNull @Initialized SplunkClientFactory clientFactory, @UnknownKeyFor @NonNull @Initialized SplunkContainer container, @UnknownKeyFor @NonNull @Initialized Builder builder) {
        super((GenericContainer)SplunkResourceManager.setup(container, builder), (TestContainerResourceManager.Builder)builder);
        String username = DEFAULT_SPLUNK_USERNAME;
        if (builder.useStaticContainer && builder.username != null) {
            username = builder.username;
        }
        this.hecPort = builder.useStaticContainer ? builder.hecPort : container.getMappedPort(builder.hecPort);
        int splunkdPort = builder.useStaticContainer ? builder.splunkdPort : container.getMappedPort(builder.splunkdPort);
        String splunkdScheme = "http";
        this.hecScheme = "http";
        this.hecToken = builder.hecToken;
        this.loginArgs = new ServiceArgs();
        this.loginArgs.setPort(splunkdPort);
        this.loginArgs.setHost(this.getHost());
        this.loginArgs.setScheme(splunkdScheme);
        this.loginArgs.setUsername(username);
        this.loginArgs.setPassword(builder.password);
        this.clientFactory = clientFactory;
    }

    private static @UnknownKeyFor @NonNull @Initialized SplunkContainer setup(@UnknownKeyFor @NonNull @Initialized SplunkContainer container, @UnknownKeyFor @NonNull @Initialized Builder builder) {
        if (builder.useStaticContainer && (builder.hecPort < 0 || builder.splunkdPort < 0)) {
            throw new SplunkResourceManagerException("This manager was configured to use a static resource, but the hecPort and splunkdPort were not properly set.");
        }
        builder.hecPort = builder.hecPort < 0 ? 8088 : builder.hecPort;
        builder.splunkdPort = builder.splunkdPort < 0 ? 8089 : builder.splunkdPort;
        builder.hecToken = builder.hecToken == null ? SplunkResourceManagerUtils.generateHecToken() : builder.hecToken;
        builder.password = builder.password == null ? SplunkResourceManagerUtils.generateSplunkPassword() : builder.password;
        return container.withDefaultsFile(Transferable.of((String)String.format("splunk:%n  hec:%n    enable: true%n    ssl: %b%n    port: %s%n    token: %s", false, builder.hecPort, builder.hecToken))).withPassword(builder.password);
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized String testId) {
        return new Builder(testId);
    }

    public @UnknownKeyFor @NonNull @Initialized String getHttpEndpoint() {
        return String.format("%s://%s:%d", this.hecScheme, this.getHost(), this.hecPort);
    }

    public @UnknownKeyFor @NonNull @Initialized String getHecEndpoint() {
        return this.getHttpEndpoint() + "/services/collector/event";
    }

    public @UnknownKeyFor @NonNull @Initialized String getHecToken() {
        return this.hecToken;
    }

    private static @UnknownKeyFor @NonNull @Initialized String splunkEventToJson(@UnknownKeyFor @NonNull @Initialized SplunkEvent event) {
        return new JSONObject(SplunkResourceManagerUtils.splunkEventToMap(event)).toString();
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean sendHttpEvent(@UnknownKeyFor @NonNull @Initialized SplunkEvent event) {
        return this.sendHttpEvents(Collections.singletonList(event));
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean sendHttpEvents(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events) {
        LOG.info("Attempting to send {} events to {}.", (Object)events.size(), (Object)this.getHecEndpoint());
        HttpPost httppost = new HttpPost(this.getHecEndpoint());
        httppost.addHeader("Authorization", "Splunk " + this.hecToken);
        StringBuilder eventsData = new StringBuilder();
        events.forEach(event -> {
            String eventStr = SplunkResourceManager.splunkEventToJson(event);
            eventsData.append(eventStr);
            LOG.info("Sending HTTP event: {}", (Object)eventStr);
        });
        try (CloseableHttpClient httpClient = this.clientFactory.getHttpClient();){
            try {
                httppost.setEntity((HttpEntity)new StringEntity(eventsData.toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw new SplunkResourceManagerException("Error setting HTTP message data to " + eventsData, e);
            }
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httppost);){
                int code = response.getStatusLine().getStatusCode();
                if (code != 200) {
                    throw new SplunkResourceManagerException("Received http error code " + code + " sending event.");
                }
            }
            catch (Exception e) {
                throw new SplunkResourceManagerException("Error sending event.", e);
            }
        }
        catch (IOException e) {
            throw new SplunkResourceManagerException("Error with HTTP client.", e);
        }
        LOG.info("Successfully sent {} events.", (Object)events.size());
        return true;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SplunkEvent> getEvents() {
        return this.getEvents("search");
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SplunkEvent> getEvents(@UnknownKeyFor @NonNull @Initialized String query) {
        LOG.info("Reading events from Splunk using query: {}.", (Object)query);
        Job job = this.clientFactory.getServiceClient(this.loginArgs).getJobs().create(query);
        Awaitility.await((String)"Retrieving events from Splunk").atMost(Duration.ofMinutes(1L)).pollInterval(Duration.ofMillis(500L)).until(() -> ((Job)job).isDone());
        ArrayList<SplunkEvent> results = new ArrayList<SplunkEvent>();
        try {
            ResultsReaderXml reader = new ResultsReaderXml(job.getEvents());
            reader.forEach(event -> results.add(SplunkEvent.newBuilder().withEvent(event.get("_raw")).withSource(event.get("source")).withSourceType(event.get("_sourcetype")).withHost(event.get("host")).withTime(Long.valueOf(OffsetDateTime.parse(event.get("_time"), DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant().toEpochMilli())).withIndex(event.get("index")).create()));
        }
        catch (Exception e) {
            throw new SplunkResourceManagerException("Error parsing XML results from Splunk.", e);
        }
        LOG.info("Successfully retrieved {} events.", (Object)results.size());
        return results;
    }

    public static final class Builder
    extends TestContainerResourceManager.Builder<SplunkResourceManager> {
        private @Nullable @UnknownKeyFor @Initialized String username = null;
        private @Nullable @UnknownKeyFor @Initialized String password = null;
        private @Nullable @UnknownKeyFor @Initialized String hecToken = null;
        private @UnknownKeyFor @NonNull @Initialized int hecPort = -1;
        private @UnknownKeyFor @NonNull @Initialized int splunkdPort = -1;

        private Builder(@UnknownKeyFor @NonNull @Initialized String testId) {
            super(testId, SplunkResourceManager.DEFAULT_SPLUNK_CONTAINER_NAME, SplunkResourceManager.DEFAULT_SPLUNK_CONTAINER_TAG);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            this.username = username;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            this.password = password;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setHecToken(@UnknownKeyFor @NonNull @Initialized String hecToken) {
            this.hecToken = hecToken;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setHost(@UnknownKeyFor @NonNull @Initialized String containerHost) {
            super.setHost(containerHost);
            this.port = 0;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setPort(@UnknownKeyFor @NonNull @Initialized int port) {
            throw new UnsupportedOperationException("Please use setHecPort() and setSplunkdPort() instead.");
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setHecPort(@UnknownKeyFor @NonNull @Initialized int port) {
            this.hecPort = port;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setSplunkdPort(@UnknownKeyFor @NonNull @Initialized int port) {
            this.splunkdPort = port;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized SplunkResourceManager build() {
            return new SplunkResourceManager(this);
        }
    }
}

