/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.splunk;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.it.common.utils.ResourceManagerUtils;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class SplunkResourceManagerUtils {
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SPLUNK_INDEX = "main";
    private static final @UnknownKeyFor @NonNull @Initialized String SPLUNK_EVENT_KEY = "event";
    private static final @UnknownKeyFor @NonNull @Initialized String SPLUNK_HOST_KEY = "host";
    private static final @UnknownKeyFor @NonNull @Initialized String SPLUNK_INDEX_KEY = "index";
    private static final @UnknownKeyFor @NonNull @Initialized String SPLUNK_TIME_KEY = "time";
    private static final @UnknownKeyFor @NonNull @Initialized String SPLUNK_SOURCE_KEY = "source";
    private static final @UnknownKeyFor @NonNull @Initialized String SPLUNK_SOURCE_TYPE_KEY = "sourcetype";
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_PASSWORD_LENGTH = 8;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_PASSWORD_LENGTH = 20;

    private SplunkResourceManagerUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> splunkEventToMap(@UnknownKeyFor @NonNull @Initialized SplunkEvent event) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put(SPLUNK_EVENT_KEY, event.event());
        eventMap.put(SPLUNK_HOST_KEY, event.host());
        eventMap.put(SPLUNK_INDEX_KEY, event.index() != null ? event.index() : DEFAULT_SPLUNK_INDEX);
        eventMap.put(SPLUNK_SOURCE_KEY, event.source());
        eventMap.put(SPLUNK_SOURCE_TYPE_KEY, event.sourceType());
        eventMap.put(SPLUNK_TIME_KEY, event.time());
        return eventMap;
    }

    static @UnknownKeyFor @NonNull @Initialized String generateSplunkPassword() {
        int numLower = 2;
        int numUpper = 2;
        int numSpecial = 0;
        return ResourceManagerUtils.generatePassword((int)8, (int)20, (int)numLower, (int)numUpper, (int)numSpecial, null);
    }

    static @UnknownKeyFor @NonNull @Initialized String generateHecToken() {
        return UUID.randomUUID().toString();
    }
}

