/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.splunk.conditions;

import com.google.auto.value.AutoValue;
import org.apache.beam.it.conditions.ConditionCheck;
import org.apache.beam.it.splunk.SplunkResourceManager;
import org.apache.beam.it.splunk.conditions.AutoValue_SplunkEventsCheck;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class SplunkEventsCheck
extends ConditionCheck {
    abstract @UnknownKeyFor @NonNull @Initialized SplunkResourceManager resourceManager();

    abstract @Nullable @UnknownKeyFor @Initialized String query();

    abstract @UnknownKeyFor @NonNull @Initialized Integer minEvents();

    abstract @Nullable @UnknownKeyFor @Initialized Integer maxEvents();

    public @UnknownKeyFor @NonNull @Initialized String getDescription() {
        if (this.maxEvents() != null) {
            return String.format("Splunk check if logs have between %d and %d events", this.minEvents(), this.maxEvents());
        }
        return String.format("Splunk check if logs have %d events", this.minEvents());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ConditionCheck.CheckResult check() {
        long totalEvents = this.query() != null ? (long)this.resourceManager().getEvents(this.query()).size() : (long)this.resourceManager().getEvents().size();
        if (totalEvents < (long)this.minEvents().intValue()) {
            return new ConditionCheck.CheckResult(false, String.format("Expected %d but has only %d", this.minEvents(), totalEvents));
        }
        if (this.maxEvents() != null && totalEvents > (long)this.maxEvents().intValue()) {
            return new ConditionCheck.CheckResult(false, String.format("Expected up to %d but found %d events", this.maxEvents(), totalEvents));
        }
        if (this.maxEvents() != null) {
            return new ConditionCheck.CheckResult(true, String.format("Expected between %d and %d events and found %d", this.minEvents(), this.maxEvents(), totalEvents));
        }
        return new ConditionCheck.CheckResult(true, String.format("Expected at least %d events and found %d", this.minEvents(), totalEvents));
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized SplunkResourceManager resourceManager) {
        return new AutoValue_SplunkEventsCheck.Builder().setResourceManager(resourceManager);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setResourceManager(@UnknownKeyFor @NonNull @Initialized SplunkResourceManager var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMinEvents(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxEvents(@UnknownKeyFor @NonNull @Initialized Integer var1);

        abstract @UnknownKeyFor @NonNull @Initialized SplunkEventsCheck autoBuild();

        public @UnknownKeyFor @NonNull @Initialized SplunkEventsCheck build() {
            return this.autoBuild();
        }
    }
}

