/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.splunk.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.it.splunk.SplunkResourceManagerUtils;
import org.apache.beam.it.truthmatchers.PipelineAsserts;
import org.apache.beam.it.truthmatchers.RecordsSubject;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SplunkAsserts {
    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> splunkEventsToRecords(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events) {
        try {
            ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
            for (SplunkEvent event : events) {
                Map<String, Object> converted = SplunkResourceManagerUtils.splunkEventToMap(event);
                records.add(converted);
            }
            return records;
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting SplunkEvents to Records", e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized RecordsSubject assertThatSplunkEvents(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events) {
        return PipelineAsserts.assertThatRecords(SplunkAsserts.splunkEventsToRecords(events));
    }
}

