/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.truthmatchers;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RecordsSubject
extends Subject {
    private final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> actual;

    protected RecordsSubject(@UnknownKeyFor @NonNull @Initialized FailureMetadata metadata, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Subject.Factory<@UnknownKeyFor @NonNull @Initialized RecordsSubject, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>>> records() {
        return RecordsSubject::new;
    }

    public void hasRows() {
        this.check("there are rows", new Object[0]).that(Integer.valueOf(this.actual.size())).isGreaterThan((Comparable)Integer.valueOf(0));
    }

    public void hasRows(@UnknownKeyFor @NonNull @Initialized int expectedRows) {
        this.check("there are %s rows", new Object[]{expectedRows}).that(Integer.valueOf(this.actual.size())).isEqualTo((Object)expectedRows);
    }

    public void hasRecord(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> record) {
        this.check("expected that contains record %s", new Object[]{record.toString()}).that(this.actual).contains(record);
    }

    public void hasRecordSubset(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> subset) {
        TreeMap<String, Object> expected = this.convertMapToTreeMap(subset);
        for (Map<String, Object> candidate : this.actual) {
            boolean match = true;
            for (Map.Entry<String, Object> entry : subset.entrySet()) {
                if (candidate.containsKey(entry.getKey()) && candidate.get(entry.getKey()).equals(entry.getValue())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return;
        }
        this.failWithoutActual(Fact.simpleFact((String)("expected that contains partial record " + expected + ", but only had " + this.actual)), new Fact[0]);
    }

    public void hasRecordsUnordered(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> records) {
        for (Map<String, Object> record : records) {
            String expected = this.convertMapToTreeMap(record).toString();
            if (!this.actual.stream().noneMatch(candidate -> this.convertMapToTreeMap((Map<String, Object>)candidate).toString().equals(expected))) continue;
            this.failWithoutActual(Fact.simpleFact((String)("expected that contains unordered record " + expected + ", but only had " + this.actual)), new Fact[0]);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> convertMapToTreeMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> record) {
        TreeMap<String, Object> result = new TreeMap<String, Object>(record);
        result.forEach((key, value) -> {
            if (value instanceof Map) {
                result.put((String)key, this.convertMapToTreeMap(((Map)value).entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue))));
            }
        });
        return result;
    }

    public void hasRecordsWithStrings(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> strings) {
        for (String expected : strings) {
            if (!this.actual.stream().noneMatch(candidate -> this.convertMapToTreeMap((Map<String, Object>)candidate).toString().contains(expected))) continue;
            this.failWithoutActual(Fact.simpleFact((String)("expected that contains the string '" + expected + "', but only had " + this.actual)), new Fact[0]);
        }
    }

    public void hasRecordsUnorderedCaseInsensitiveColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> records) {
        for (Map<String, Object> record : records) {
            String expected = this.convertKeysToUpperCase(this.convertMapToTreeMap(record)).toString();
            if (!this.actual.stream().noneMatch(candidate -> this.convertKeysToUpperCase(this.convertMapToTreeMap((Map<String, Object>)candidate)).toString().equals(expected))) continue;
            this.failWithoutActual(Fact.simpleFact((String)("expected that contains unordered record (and case insensitive) " + expected + ", but only had " + this.actual)), new Fact[0]);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> convertKeysToUpperCase(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map) {
        return this.convertMapToTreeMap(map.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), Map.Entry::getValue)));
    }

    public void hasRecordUnordered(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> record) {
        this.hasRecordsUnordered(Collections.singletonList(record));
    }

    public void hasRecords(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> records) {
        this.check("records %s are there", new Object[]{records.toString()}).that(this.actual).containsExactlyElementsIn(records);
    }

    public void allMatch(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> record) {
        List<Map<String, Object>> records = Collections.nCopies(this.actual.size(), record);
        this.hasRecords(records);
    }
}

