/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1.io.grpc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.vendor.grpc.v1.io.grpc.Context;

final class ThreadLocalContextStorage
extends Context.Storage {
    private static final Logger log = Logger.getLogger(ThreadLocalContextStorage.class.getName());
    private static final ThreadLocal<Context> localContext = new ThreadLocal();

    ThreadLocalContextStorage() {
    }

    @Override
    public Context doAttach(Context toAttach) {
        Context current = this.current();
        localContext.set(toAttach);
        return current;
    }

    @Override
    public void detach(Context toDetach, Context toRestore) {
        if (this.current() != toDetach) {
            log.log(Level.SEVERE, "Context was not attached when detaching", new Throwable().fillInStackTrace());
        }
        this.doAttach(toRestore);
    }

    @Override
    public Context current() {
        return localContext.get();
    }
}

