/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PipelineOptionsSerializationUtils;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;

public class SerializablePipelineOptions
implements Serializable {
    private final String serializedPipelineOptions;
    private transient PipelineOptions options;

    public SerializablePipelineOptions(PipelineOptions options) {
        this.serializedPipelineOptions = PipelineOptionsSerializationUtils.serializeToJson(options);
        this.options = options;
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
    }

    public PipelineOptions get() {
        return this.options;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.options = PipelineOptionsSerializationUtils.deserializeFromJson(this.serializedPipelineOptions);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options);
    }
}

