/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.MetricName;

@Experimental(value=Experimental.Kind.METRICS)
public class DistributionCell
implements Distribution,
MetricCell<DistributionData> {
    private final DirtyState dirty = new DirtyState();
    private final AtomicReference<DistributionData> value = new AtomicReference<DistributionData>(DistributionData.EMPTY);
    private final MetricName name;

    @Internal
    public DistributionCell(MetricName name) {
        this.name = name;
    }

    public void update(long n) {
        this.update(DistributionData.singleton(n));
    }

    public void update(long sum, long count, long min, long max) {
        this.update(DistributionData.create(sum, count, min, max));
    }

    void update(DistributionData data) {
        DistributionData original;
        while (!this.value.compareAndSet(original = this.value.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public DistributionData getCumulative() {
        return this.value.get();
    }

    public MetricName getName() {
        return this.name;
    }
}

