/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.metrics.MetricFiltering;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.metrics.MetricKey;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricUpdates;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class MetricsContainerStepMap
implements Serializable {
    private Map<String, MetricsContainerImpl> metricsContainers;
    private MetricsContainerImpl unboundContainer = new MetricsContainerImpl(null);

    public MetricsContainerStepMap() {
        this.metricsContainers = new ConcurrentHashMap<String, MetricsContainerImpl>();
    }

    public MetricsContainerImpl getUnboundContainer() {
        return this.unboundContainer;
    }

    public MetricsContainerImpl getContainer(String stepName) {
        if (stepName == null) {
            return this.getUnboundContainer();
        }
        if (!this.metricsContainers.containsKey(stepName)) {
            this.metricsContainers.put(stepName, new MetricsContainerImpl(stepName));
        }
        return this.metricsContainers.get(stepName);
    }

    public void updateAll(MetricsContainerStepMap other) {
        for (Map.Entry<String, MetricsContainerImpl> container : other.metricsContainers.entrySet()) {
            this.getContainer(container.getKey()).update(container.getValue());
        }
        this.getUnboundContainer().update(other.getUnboundContainer());
    }

    public void update(String step, MetricsContainerImpl container) {
        this.getContainer(step).update(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsContainerStepMap that = (MetricsContainerStepMap)o;
        return this.getMetricsContainers().equals(that.getMetricsContainers());
    }

    public int hashCode() {
        return this.metricsContainers.hashCode();
    }

    public static MetricResults asMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers) {
        return new MetricsContainerStepMapMetricResults(attemptedMetricsContainers, committedMetricsContainers);
    }

    public Iterable<BeamFnApi.MonitoringInfo> getMonitoringInfos() {
        ArrayList<BeamFnApi.MonitoringInfo> monitoringInfos = new ArrayList<BeamFnApi.MonitoringInfo>();
        for (MetricsContainerImpl container : this.getMetricsContainers()) {
            for (BeamFnApi.MonitoringInfo mi : container.getMonitoringInfos()) {
                monitoringInfos.add(mi);
            }
        }
        return monitoringInfos;
    }

    public static MetricResults asAttemptedOnlyMetricResults(MetricsContainerStepMap attemptedMetricsContainers) {
        return new MetricsContainerStepMapMetricResults(attemptedMetricsContainers);
    }

    private Iterable<MetricsContainerImpl> getMetricsContainers() {
        return Iterables.concat(this.metricsContainers.values(), Collections.singleton(this.unboundContainer));
    }

    private static class MetricsContainerStepMapMetricResults
    extends MetricResults {
        private final Map<MetricKey, AttemptedAndCommitted<Long>> counters = new HashMap<MetricKey, AttemptedAndCommitted<Long>>();
        private final Map<MetricKey, AttemptedAndCommitted<DistributionData>> distributions = new HashMap<MetricKey, AttemptedAndCommitted<DistributionData>>();
        private final Map<MetricKey, AttemptedAndCommitted<GaugeData>> gauges = new HashMap<MetricKey, AttemptedAndCommitted<GaugeData>>();
        private final boolean isCommittedSupported;

        private MetricsContainerStepMapMetricResults(MetricsContainerStepMap attemptedMetricsContainers) {
            this(attemptedMetricsContainers, new MetricsContainerStepMap(), false);
        }

        private MetricsContainerStepMapMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers) {
            this(attemptedMetricsContainers, committedMetricsContainers, true);
        }

        private MetricsContainerStepMapMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers, boolean isCommittedSupported) {
            MetricUpdates cumulative;
            for (MetricsContainerImpl container : attemptedMetricsContainers.getMetricsContainers()) {
                cumulative = container.getCumulative();
                this.mergeCounters(this.counters, cumulative.counterUpdates(), this.attemptedCounterUpdateFn());
                this.mergeDistributions(this.distributions, cumulative.distributionUpdates(), this.attemptedDistributionUpdateFn());
                this.mergeGauges(this.gauges, cumulative.gaugeUpdates(), this.attemptedGaugeUpdateFn());
            }
            for (MetricsContainerImpl container : committedMetricsContainers.getMetricsContainers()) {
                cumulative = container.getCumulative();
                this.mergeCounters(this.counters, cumulative.counterUpdates(), this.committedCounterUpdateFn());
                this.mergeDistributions(this.distributions, cumulative.distributionUpdates(), this.committedDistributionUpdateFn());
                this.mergeGauges(this.gauges, cumulative.gaugeUpdates(), this.committedGaugeUpdateFn());
            }
            this.isCommittedSupported = isCommittedSupported;
        }

        private Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>> attemptedDistributionUpdateFn() {
            return input -> {
                MetricKey key = input.getKey();
                return new AttemptedAndCommitted(key, (MetricUpdates.MetricUpdate)input, MetricUpdates.MetricUpdate.create(key, DistributionData.EMPTY));
            };
        }

        private Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>> committedDistributionUpdateFn() {
            return input -> {
                MetricKey key = input.getKey();
                return new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, DistributionData.EMPTY), (MetricUpdates.MetricUpdate)input);
            };
        }

        private Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>> attemptedGaugeUpdateFn() {
            return input -> {
                MetricKey key = input.getKey();
                return new AttemptedAndCommitted(key, (MetricUpdates.MetricUpdate)input, MetricUpdates.MetricUpdate.create(key, GaugeData.empty()));
            };
        }

        private Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>> committedGaugeUpdateFn() {
            return input -> {
                MetricKey key = input.getKey();
                return new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, GaugeData.empty()), (MetricUpdates.MetricUpdate)input);
            };
        }

        private Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>> attemptedCounterUpdateFn() {
            return input -> {
                MetricKey key = input.getKey();
                return new AttemptedAndCommitted(key, (MetricUpdates.MetricUpdate)input, MetricUpdates.MetricUpdate.create(key, 0L));
            };
        }

        private Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>> committedCounterUpdateFn() {
            return input -> {
                MetricKey key = input.getKey();
                return new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, 0L), (MetricUpdates.MetricUpdate)input);
            };
        }

        public String toString() {
            return this.queryMetrics(null).toString();
        }

        public MetricQueryResults queryMetrics(@Nullable MetricsFilter filter) {
            return new QueryResults(filter);
        }

        private Function<AttemptedAndCommitted<Long>, MetricResult<Long>> counterUpdateToResult() {
            return metricResult -> {
                MetricKey key = ((AttemptedAndCommitted)metricResult).getKey();
                return new AccumulatedMetricResult(key.metricName(), key.stepName(), (Long)((AttemptedAndCommitted)metricResult).getAttempted().getUpdate(), this.isCommittedSupported ? (Long)((AttemptedAndCommitted)metricResult).getCommitted().getUpdate() : null, this.isCommittedSupported);
            };
        }

        private Function<AttemptedAndCommitted<DistributionData>, MetricResult<DistributionResult>> distributionUpdateToResult() {
            return metricResult -> {
                MetricKey key = ((AttemptedAndCommitted)metricResult).getKey();
                return new AccumulatedMetricResult(key.metricName(), key.stepName(), ((DistributionData)((AttemptedAndCommitted)metricResult).getAttempted().getUpdate()).extractResult(), this.isCommittedSupported ? ((DistributionData)((AttemptedAndCommitted)metricResult).getCommitted().getUpdate()).extractResult() : null, this.isCommittedSupported);
            };
        }

        private Function<AttemptedAndCommitted<GaugeData>, MetricResult<GaugeResult>> gaugeUpdateToResult() {
            return metricResult -> {
                MetricKey key = ((AttemptedAndCommitted)metricResult).getKey();
                return new AccumulatedMetricResult(key.metricName(), key.stepName(), ((GaugeData)((AttemptedAndCommitted)metricResult).getAttempted().getUpdate()).extractResult(), this.isCommittedSupported ? ((GaugeData)((AttemptedAndCommitted)metricResult).getCommitted().getUpdate()).extractResult() : null, this.isCommittedSupported);
            };
        }

        private void mergeCounters(Map<MetricKey, AttemptedAndCommitted<Long>> counters, Iterable<MetricUpdates.MetricUpdate<Long>> updates, Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>> updateToAttemptedAndCommittedFn) {
            for (MetricUpdates.MetricUpdate<Long> metricUpdate : updates) {
                MetricKey key = metricUpdate.getKey();
                AttemptedAndCommitted update = (AttemptedAndCommitted)updateToAttemptedAndCommittedFn.apply(metricUpdate);
                if (counters.containsKey(key)) {
                    AttemptedAndCommitted<Long> current = counters.get(key);
                    update = new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, (Long)update.getAttempted().getUpdate() + (Long)((AttemptedAndCommitted)current).getAttempted().getUpdate()), MetricUpdates.MetricUpdate.create(key, (Long)update.getCommitted().getUpdate() + (Long)((AttemptedAndCommitted)current).getCommitted().getUpdate()));
                }
                counters.put(key, update);
            }
        }

        private void mergeDistributions(Map<MetricKey, AttemptedAndCommitted<DistributionData>> distributions, Iterable<MetricUpdates.MetricUpdate<DistributionData>> updates, Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>> updateToAttemptedAndCommittedFn) {
            for (MetricUpdates.MetricUpdate<DistributionData> metricUpdate : updates) {
                MetricKey key = metricUpdate.getKey();
                AttemptedAndCommitted update = (AttemptedAndCommitted)updateToAttemptedAndCommittedFn.apply(metricUpdate);
                if (distributions.containsKey(key)) {
                    AttemptedAndCommitted<DistributionData> current = distributions.get(key);
                    update = new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, ((DistributionData)update.getAttempted().getUpdate()).combine((DistributionData)((AttemptedAndCommitted)current).getAttempted().getUpdate())), MetricUpdates.MetricUpdate.create(key, ((DistributionData)update.getCommitted().getUpdate()).combine((DistributionData)((AttemptedAndCommitted)current).getCommitted().getUpdate())));
                }
                distributions.put(key, update);
            }
        }

        private void mergeGauges(Map<MetricKey, AttemptedAndCommitted<GaugeData>> gauges, Iterable<MetricUpdates.MetricUpdate<GaugeData>> updates, Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>> updateToAttemptedAndCommittedFn) {
            for (MetricUpdates.MetricUpdate<GaugeData> metricUpdate : updates) {
                MetricKey key = metricUpdate.getKey();
                AttemptedAndCommitted update = (AttemptedAndCommitted)updateToAttemptedAndCommittedFn.apply(metricUpdate);
                if (gauges.containsKey(key)) {
                    AttemptedAndCommitted<GaugeData> current = gauges.get(key);
                    update = new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, ((GaugeData)update.getAttempted().getUpdate()).combine((GaugeData)((AttemptedAndCommitted)current).getAttempted().getUpdate())), MetricUpdates.MetricUpdate.create(key, ((GaugeData)update.getCommitted().getUpdate()).combine((GaugeData)((AttemptedAndCommitted)current).getCommitted().getUpdate())));
                }
                gauges.put(key, update);
            }
        }

        private static class AttemptedAndCommitted<T> {
            private final MetricKey key;
            private final MetricUpdates.MetricUpdate<T> attempted;
            private final MetricUpdates.MetricUpdate<T> committed;

            private AttemptedAndCommitted(MetricKey key, MetricUpdates.MetricUpdate<T> attempted, MetricUpdates.MetricUpdate<T> committed) {
                this.key = key;
                this.attempted = attempted;
                this.committed = committed;
            }

            private MetricKey getKey() {
                return this.key;
            }

            private MetricUpdates.MetricUpdate<T> getAttempted() {
                return this.attempted;
            }

            private MetricUpdates.MetricUpdate<T> getCommitted() {
                return this.committed;
            }
        }

        private static class AccumulatedMetricResult<T>
        implements MetricResult<T> {
            private final MetricName name;
            private final String step;
            private final T attempted;
            @Nullable
            private final T committed;
            private final boolean isCommittedSupported;

            private AccumulatedMetricResult(MetricName name, String step, T attempted, @Nullable T committed, boolean isCommittedSupported) {
                this.name = name;
                this.step = step;
                this.attempted = attempted;
                this.committed = committed;
                this.isCommittedSupported = isCommittedSupported;
            }

            public MetricName getName() {
                return this.name;
            }

            public String getStep() {
                return this.step;
            }

            public T getCommitted() {
                if (!this.isCommittedSupported) {
                    throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
                }
                return this.committed;
            }

            public T getAttempted() {
                return this.attempted;
            }
        }

        private class QueryResults
        extends MetricQueryResults {
            private final MetricsFilter filter;

            private QueryResults(MetricsFilter filter) {
                this.filter = filter;
            }

            public Iterable<MetricResult<Long>> getCounters() {
                return FluentIterable.from(MetricsContainerStepMapMetricResults.this.counters.values()).filter(this.matchesFilter(this.filter)).transform(MetricsContainerStepMapMetricResults.this.counterUpdateToResult()).toList();
            }

            public Iterable<MetricResult<DistributionResult>> getDistributions() {
                return FluentIterable.from(MetricsContainerStepMapMetricResults.this.distributions.values()).filter(this.matchesFilter(this.filter)).transform(MetricsContainerStepMapMetricResults.this.distributionUpdateToResult()).toList();
            }

            public Iterable<MetricResult<GaugeResult>> getGauges() {
                return FluentIterable.from(MetricsContainerStepMapMetricResults.this.gauges.values()).filter(this.matchesFilter(this.filter)).transform(MetricsContainerStepMapMetricResults.this.gaugeUpdateToResult()).toList();
            }

            private Predicate<AttemptedAndCommitted<?>> matchesFilter(MetricsFilter filter) {
                return attemptedAndCommitted -> MetricFiltering.matches(filter, ((AttemptedAndCommitted)attemptedAndCommitted).getKey());
            }
        }
    }
}

