/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.time.Instant;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.SpecMonitoringInfoValidator;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMonitoringInfoBuilder {
    public static final String ELEMENT_COUNT_URN = BeamUrns.getUrn((ProtocolMessageEnum)BeamFnApi.MonitoringInfoUrns.Enum.ELEMENT_COUNT);
    public static final String START_BUNDLE_MSECS_URN = BeamUrns.getUrn((ProtocolMessageEnum)BeamFnApi.MonitoringInfoUrns.Enum.START_BUNDLE_MSECS);
    public static final String PROCESS_BUNDLE_MSECS_URN = BeamUrns.getUrn((ProtocolMessageEnum)BeamFnApi.MonitoringInfoUrns.Enum.PROCESS_BUNDLE_MSECS);
    public static final String FINISH_BUNDLE_MSECS_URN = BeamUrns.getUrn((ProtocolMessageEnum)BeamFnApi.MonitoringInfoUrns.Enum.FINISH_BUNDLE_MSECS);
    public static final String USER_COUNTER_URN_PREFIX = BeamUrns.getUrn((ProtocolMessageEnum)BeamFnApi.MonitoringInfoUrns.Enum.USER_COUNTER_URN_PREFIX);
    public static final String SUM_INT64_TYPE_URN = BeamUrns.getUrn((ProtocolMessageEnum)BeamFnApi.MonitoringInfoTypeUrns.Enum.SUM_INT64_TYPE);
    private static final HashMap<String, BeamFnApi.MonitoringInfoSpec> specs = new HashMap();
    public static final String PCOLLECTION_LABEL = SimpleMonitoringInfoBuilder.getLabelString(BeamFnApi.MonitoringInfo.MonitoringInfoLabels.PCOLLECTION);
    public static final String PTRANSFORM_LABEL = SimpleMonitoringInfoBuilder.getLabelString(BeamFnApi.MonitoringInfo.MonitoringInfoLabels.TRANSFORM);
    private final boolean validateAndDropInvalid;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMonitoringInfoBuilder.class);
    private BeamFnApi.MonitoringInfo.Builder builder;
    private SpecMonitoringInfoValidator validator = new SpecMonitoringInfoValidator();

    private static String getLabelString(BeamFnApi.MonitoringInfo.MonitoringInfoLabels label) {
        BeamFnApi.MonitoringInfoLabelProps props = (BeamFnApi.MonitoringInfoLabelProps)label.getValueDescriptor().getOptions().getExtension(BeamFnApi.labelProps);
        return props.getName();
    }

    public SimpleMonitoringInfoBuilder() {
        this(true);
    }

    public SimpleMonitoringInfoBuilder(boolean validateAndDropInvalid) {
        this.builder = BeamFnApi.MonitoringInfo.newBuilder();
        this.validateAndDropInvalid = validateAndDropInvalid;
    }

    public static String userMetricUrn(String metricNamespace, String metricName) {
        String fixedMetricNamespace = metricNamespace.replace(':', '_');
        String fixedMetricName = metricName.replace(':', '_');
        StringBuilder sb = new StringBuilder();
        sb.append(USER_COUNTER_URN_PREFIX);
        sb.append(fixedMetricNamespace);
        sb.append(':');
        sb.append(fixedMetricName);
        return sb.toString();
    }

    public SimpleMonitoringInfoBuilder setUrn(String urn) {
        this.builder.setUrn(urn);
        return this;
    }

    public SimpleMonitoringInfoBuilder setUrnForUserMetric(String namespace, String name) {
        this.builder.setUrn(SimpleMonitoringInfoBuilder.userMetricUrn(namespace, name));
        return this;
    }

    public SimpleMonitoringInfoBuilder setTimestampToNow() {
        Instant time = Instant.now();
        this.builder.getTimestampBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano());
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64Value(long value) {
        this.builder.getMetricBuilder().getCounterDataBuilder().setInt64Value(value);
        this.setInt64TypeUrn();
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64TypeUrn() {
        this.builder.setType(SUM_INT64_TYPE_URN);
        return this;
    }

    public SimpleMonitoringInfoBuilder setPTransformLabel(String pTransform) {
        this.setLabel(PTRANSFORM_LABEL, pTransform);
        return this;
    }

    public SimpleMonitoringInfoBuilder setPCollectionLabel(String pCollection) {
        this.setLabel(PCOLLECTION_LABEL, pCollection);
        return this;
    }

    public SimpleMonitoringInfoBuilder setLabel(String labelName, String labelValue) {
        this.builder.putLabels(labelName, labelValue);
        return this;
    }

    public void clearAndMerge(BeamFnApi.MonitoringInfo monitoringInfo) {
        this.builder = BeamFnApi.MonitoringInfo.newBuilder();
        this.builder.mergeFrom(monitoringInfo);
    }

    @VisibleForTesting
    public static BeamFnApi.MonitoringInfo clearTimestamp(BeamFnApi.MonitoringInfo input) {
        BeamFnApi.MonitoringInfo.Builder builder = BeamFnApi.MonitoringInfo.newBuilder();
        builder.mergeFrom(input);
        builder.clearTimestamp();
        return builder.build();
    }

    @Nullable
    public BeamFnApi.MonitoringInfo build() {
        BeamFnApi.MonitoringInfo result = this.builder.build();
        if (this.validateAndDropInvalid && this.validator.validate(result).isPresent()) {
            return null;
        }
        return result;
    }

    static {
        for (BeamFnApi.MonitoringInfoSpecs.Enum val : BeamFnApi.MonitoringInfoSpecs.Enum.values()) {
            if (val.name().equals("UNRECOGNIZED")) continue;
            BeamFnApi.MonitoringInfoSpec spec = (BeamFnApi.MonitoringInfoSpec)val.getValueDescriptor().getOptions().getExtension(BeamFnApi.monitoringInfoSpec);
            specs.put(spec.getUrn(), spec);
        }
    }
}

