/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.SimpleExecutionState;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;

public class SimpleStateRegistry {
    private List<SimpleExecutionState> executionStates = new ArrayList<SimpleExecutionState>();

    public void register(SimpleExecutionState state) {
        this.executionStates.add(state);
    }

    public List<BeamFnApi.MonitoringInfo> getExecutionTimeMonitoringInfos() {
        ArrayList<BeamFnApi.MonitoringInfo> monitoringInfos = new ArrayList<BeamFnApi.MonitoringInfo>();
        for (SimpleExecutionState state : this.executionStates) {
            SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder();
            builder.setUrn(state.getUrn());
            for (Map.Entry<String, String> entry : state.getLabels().entrySet()) {
                builder.setLabel(entry.getKey(), entry.getValue());
            }
            builder.setInt64Value(state.getTotalMillis());
            monitoringInfos.add(builder.build());
        }
        return monitoringInfos;
    }
}

