/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;

public class SpecMonitoringInfoValidator {
    protected final BeamFnApi.MonitoringInfoSpec[] specs = (BeamFnApi.MonitoringInfoSpec[])Arrays.stream(BeamFnApi.MonitoringInfoSpecs.Enum.values()).filter(x -> !x.name().equals("UNRECOGNIZED")).map(x -> (BeamFnApi.MonitoringInfoSpec)x.getValueDescriptor().getOptions().getExtension(BeamFnApi.monitoringInfoSpec)).toArray(BeamFnApi.MonitoringInfoSpec[]::new);

    public Optional<String> validate(BeamFnApi.MonitoringInfo monitoringInfo) {
        BeamFnApi.MonitoringInfoSpec spec = null;
        for (BeamFnApi.MonitoringInfoSpec specIterator : this.specs) {
            if (!monitoringInfo.getUrn().startsWith(specIterator.getUrn())) continue;
            spec = specIterator;
            break;
        }
        if (spec == null) {
            return Optional.empty();
        }
        if (!monitoringInfo.getType().equals(spec.getTypeUrn())) {
            return Optional.of(String.format("Monitoring info with urn: %s should have type: %s, received %s", monitoringInfo.getUrn(), spec.getTypeUrn(), monitoringInfo.getType()));
        }
        HashSet requiredLabels = new HashSet(spec.getRequiredLabelsList());
        if (!monitoringInfo.getLabelsMap().keySet().containsAll(requiredLabels)) {
            return Optional.of(String.format("MonitoringInfo with urn: %s should have labels: %s, actual: %s", monitoringInfo.getUrn(), requiredLabels, monitoringInfo.getLabelsMap()));
        }
        return Optional.empty();
    }
}

