/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core;

import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.TimerInternals;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.CounterCell;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class LateDataUtils {
    private LateDataUtils() {
    }

    public static Instant garbageCollectionTime(BoundedWindow window, WindowingStrategy windowingStrategy) {
        return LateDataUtils.garbageCollectionTime(window, windowingStrategy.getAllowedLateness());
    }

    public static Instant garbageCollectionTime(BoundedWindow window, Duration allowedLateness) {
        if (GlobalWindow.INSTANCE.maxTimestamp().minus((ReadableDuration)allowedLateness).isBefore((ReadableInstant)window.maxTimestamp())) {
            return GlobalWindow.INSTANCE.maxTimestamp();
        }
        return window.maxTimestamp().plus((ReadableDuration)allowedLateness);
    }

    public static <K, V> Iterable<WindowedValue<V>> dropExpiredWindows(K key, Iterable<WindowedValue<V>> elements, TimerInternals timerInternals, WindowingStrategy<?, ?> windowingStrategy, CounterCell droppedDueToLateness) {
        return FluentIterable.from(elements).transformAndConcat(input -> {
            if (input == null) {
                return null;
            }
            return input.explodeWindows();
        }).filter(input -> {
            if (input == null) {
                return false;
            }
            BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement((Iterable)input.getWindows());
            boolean expired = window.maxTimestamp().plus((ReadableDuration)windowingStrategy.getAllowedLateness()).isBefore((ReadableInstant)timerInternals.currentInputWatermarkTime());
            if (expired) {
                droppedDueToLateness.inc();
                WindowTracing.debug((String)"GroupAlsoByWindow: Dropping element at {} for key: {}; window: {} since it is too far behind inputWatermark: {}", (Object[])new Object[]{input.getTimestamp(), key, window, timerInternals.currentInputWatermarkTime()});
            }
            return !expired;
        });
    }
}

