/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.StateInternals;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.StateTags;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class SideInputHandler
implements ReadyCheckingSideInputReader {
    protected final Collection<PCollectionView<?>> sideInputs;
    private final StateInternals stateInternals;
    private final Map<PCollectionView<?>, StateTag<CombiningState<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>>>> availableWindowsTags;
    private final Map<PCollectionView<?>, StateTag<ValueState<Iterable<?>>>> sideInputContentsTags;

    public SideInputHandler(Collection<PCollectionView<?>> sideInputs, StateInternals stateInternals) {
        this.sideInputs = sideInputs;
        this.stateInternals = stateInternals;
        this.availableWindowsTags = new HashMap();
        this.sideInputContentsTags = new HashMap();
        for (PCollectionView<?> sideInput : sideInputs) {
            Preconditions.checkArgument((boolean)Materializations.MULTIMAP_MATERIALIZATION_URN.equals(sideInput.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", (Object)Materializations.MULTIMAP_MATERIALIZATION_URN, (Object)sideInput.getViewFn().getMaterialization().getUrn(), (Object)sideInput.getTagInternal().getId());
            Coder windowCoder = sideInput.getWindowingStrategyInternal().getWindowFn().windowCoder();
            StateTag<CombiningState<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>>> availableTag = StateTags.combiningValue("side-input-available-windows-" + sideInput.getTagInternal().getId(), SetCoder.of((Coder)windowCoder), new WindowSetCombineFn());
            this.availableWindowsTags.put(sideInput, availableTag);
            StateTag stateTag = StateTags.value("side-input-data-" + sideInput.getTagInternal().getId(), IterableCoder.of((Coder)sideInput.getCoderInternal()));
            this.sideInputContentsTags.put(sideInput, stateTag);
        }
    }

    public void addSideInputValue(PCollectionView<?> sideInput, WindowedValue<Iterable<?>> value) {
        Coder windowCoder = sideInput.getWindowingStrategyInternal().getWindowFn().windowCoder();
        StateTag<ValueState<Iterable<?>>> stateTag = this.sideInputContentsTags.get(sideInput);
        for (BoundedWindow window : value.getWindows()) {
            this.stateInternals.state(StateNamespaces.window(windowCoder, window), stateTag).write((Object)((Iterable)value.getValue()));
            this.stateInternals.state(StateNamespaces.global(), this.availableWindowsTags.get(sideInput)).add((Object)window);
        }
    }

    @Override
    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Iterable elements = this.getIterable(view, window);
        ViewFn viewFn = view.getViewFn();
        Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
        return (T)viewFn.apply(InMemoryMultimapSideInputView.fromIterable(keyCoder, elements));
    }

    public <T> Iterable<?> getIterable(PCollectionView<T> view, BoundedWindow window) {
        Coder windowCoder = view.getWindowingStrategyInternal().getWindowFn().windowCoder();
        StateTag<ValueState<Iterable<?>>> stateTag = this.sideInputContentsTags.get(view);
        ValueState<Iterable<?>> state = this.stateInternals.state(StateNamespaces.window(windowCoder, window), stateTag);
        List elements = (List)state.read();
        return elements != null ? elements : Collections.emptyList();
    }

    @Override
    public boolean isReady(PCollectionView<?> sideInput, BoundedWindow window) {
        Set readyWindows = (Set)this.stateInternals.state(StateNamespaces.global(), this.availableWindowsTags.get(sideInput)).read();
        return readyWindows != null && readyWindows.contains(window);
    }

    @Override
    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.contains(view);
    }

    @Override
    public boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }

    private static class WindowSetCombineFn
    extends Combine.CombineFn<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>> {
        private WindowSetCombineFn() {
        }

        public Set<BoundedWindow> createAccumulator() {
            return new HashSet<BoundedWindow>();
        }

        public Set<BoundedWindow> addInput(Set<BoundedWindow> accumulator, BoundedWindow input) {
            accumulator.add(input);
            return accumulator;
        }

        public Set<BoundedWindow> mergeAccumulators(Iterable<Set<BoundedWindow>> accumulators) {
            HashSet<BoundedWindow> result = new HashSet<BoundedWindow>();
            for (Set<BoundedWindow> acc : accumulators) {
                result.addAll(acc);
            }
            return result;
        }

        public Set<BoundedWindow> extractOutput(Set<BoundedWindow> accumulator) {
            return accumulator;
        }
    }
}

