/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public abstract class SplittableProcessElementInvoker<InputT, OutputT, RestrictionT, PositionT> {
    public abstract Result invokeProcessElement(DoFnInvoker<InputT, OutputT> var1, WindowedValue<InputT> var2, RestrictionTracker<RestrictionT, PositionT> var3);

    public class Result {
        @Nullable
        private final RestrictionT residualRestriction;
        private final DoFn.ProcessContinuation continuation;
        @Nullable
        private final Instant futureOutputWatermark;

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Spotbugs incorrectly thinks continuation is marked @Nullable")
        public Result(RestrictionT residualRestriction, @Nullable DoFn.ProcessContinuation continuation, Instant futureOutputWatermark) {
            Preconditions.checkArgument((continuation != null ? 1 : 0) != 0, (Object)"continuation must not be null");
            this.continuation = continuation;
            if (continuation.shouldResume()) {
                Preconditions.checkArgument((residualRestriction != null ? 1 : 0) != 0, (Object)"residual restriction must not be null if continuation indicate it should resume");
            }
            this.residualRestriction = residualRestriction;
            this.futureOutputWatermark = futureOutputWatermark;
        }

        @Nullable
        public RestrictionT getResidualRestriction() {
            return this.residualRestriction;
        }

        public DoFn.ProcessContinuation getContinuation() {
            return this.continuation;
        }

        @Nullable
        public Instant getFutureOutputWatermark() {
            return this.futureOutputWatermark;
        }
    }
}

