/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph;

import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineTrimmer {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineTrimmer.class);

    public static RunnerApi.Pipeline trim(RunnerApi.Pipeline pipeline, Set<String> knownUrns) {
        return PipelineTrimmer.makeKnownUrnsPrimitives(pipeline, knownUrns);
    }

    private static RunnerApi.Pipeline makeKnownUrnsPrimitives(RunnerApi.Pipeline pipeline, Set<String> knownUrns) {
        RunnerApi.Pipeline.Builder trimmedPipeline = pipeline.toBuilder();
        for (String ptransformId : pipeline.getComponents().getTransformsMap().keySet()) {
            if (!knownUrns.contains(pipeline.getComponents().getTransformsOrThrow(ptransformId).getSpec().getUrn())) continue;
            LOG.debug("Removing descendants of known PTransform {}" + ptransformId);
            PipelineTrimmer.removeDescendants(trimmedPipeline, ptransformId);
        }
        return trimmedPipeline.build();
    }

    private static void removeDescendants(RunnerApi.Pipeline.Builder pipeline, String parentId) {
        RunnerApi.PTransform parentProto = pipeline.getComponents().getTransformsOrDefault(parentId, null);
        if (parentProto != null) {
            for (String childId : parentProto.getSubtransformsList()) {
                PipelineTrimmer.removeDescendants(pipeline, childId);
                pipeline.getComponentsBuilder().removeTransforms(childId);
            }
            pipeline.getComponentsBuilder().putTransforms(parentId, parentProto.toBuilder().clearSubtransforms().build());
        }
    }
}

