/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricName;

@Experimental(value=Experimental.Kind.METRICS)
public class CounterCell
implements Counter,
MetricCell<Long> {
    private final DirtyState dirty = new DirtyState();
    private final AtomicLong value = new AtomicLong();
    private final MetricName name;

    @Internal
    public CounterCell(MetricName name) {
        this.name = name;
    }

    public void inc(long n) {
        this.value.addAndGet(n);
        this.dirty.afterModification();
    }

    public void inc() {
        this.inc(1L);
    }

    public void dec() {
        this.inc(-1L);
    }

    public void dec(long n) {
        this.inc(-1L * n);
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public Long getCumulative() {
        return this.value.get();
    }

    public MetricName getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof CounterCell) {
            CounterCell counterCell = (CounterCell)object;
            return Objects.equals(this.dirty, counterCell.dirty) && Objects.equals(this.value.get(), counterCell.value.get()) && Objects.equals(this.name, counterCell.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dirty, this.value.get(), this.name);
    }
}

