/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.CounterCell;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.DistributionCell;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.GaugeCell;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricUpdates;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricsMap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.METRICS)
public class MetricsContainerImpl
implements Serializable,
MetricsContainer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsContainerImpl.class);
    @Nullable
    private final String stepName;
    private MetricsMap<MetricName, CounterCell> counters = new MetricsMap<MetricName, CounterCell>(CounterCell::new);
    private MetricsMap<MetricName, DistributionCell> distributions = new MetricsMap<MetricName, DistributionCell>(DistributionCell::new);
    private MetricsMap<MetricName, GaugeCell> gauges = new MetricsMap<MetricName, GaugeCell>(GaugeCell::new);

    public MetricsContainerImpl(@Nullable String stepName) {
        this.stepName = stepName;
    }

    public CounterCell getCounter(MetricName metricName) {
        return this.counters.get(metricName);
    }

    @Nullable
    public CounterCell tryGetCounter(MetricName metricName) {
        return this.counters.tryGet(metricName);
    }

    public DistributionCell getDistribution(MetricName metricName) {
        return this.distributions.get(metricName);
    }

    @Nullable
    public DistributionCell tryGetDistribution(MetricName metricName) {
        return this.distributions.tryGet(metricName);
    }

    public GaugeCell getGauge(MetricName metricName) {
        return this.gauges.get(metricName);
    }

    @Nullable
    public GaugeCell tryGetGauge(MetricName metricName) {
        return this.gauges.tryGet(metricName);
    }

    private <UpdateT, CellT extends MetricCell<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractUpdates(MetricsMap<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            if (!((MetricCell)cell.getValue()).getDirty().beforeCommit()) continue;
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create((String)this.stepName, (MetricName)cell.getKey()), ((MetricCell)cell.getValue()).getCumulative()));
        }
        return updates.build();
    }

    public MetricUpdates getUpdates() {
        return MetricUpdates.create(this.extractUpdates(this.counters), this.extractUpdates(this.distributions), this.extractUpdates(this.gauges));
    }

    @Nullable
    private MetricsApi.MonitoringInfo counterUpdateToMonitoringInfo(MetricUpdates.MetricUpdate<Long> metricUpdate) {
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder(true);
        MetricName metricName = metricUpdate.getKey().metricName();
        if (metricName instanceof MonitoringInfoMetricName) {
            MonitoringInfoMetricName monitoringInfoName = (MonitoringInfoMetricName)metricName;
            builder.setUrn(monitoringInfoName.getUrn());
            for (Map.Entry<String, String> e : monitoringInfoName.getLabels().entrySet()) {
                builder.setLabel(e.getKey(), e.getValue());
            }
        } else {
            if (this.stepName == null) {
                return null;
            }
            builder.setUrn(MonitoringInfoConstants.Urns.USER_COUNTER).setLabel(MonitoringInfoConstants.Labels.NAMESPACE, metricUpdate.getKey().metricName().getNamespace()).setLabel(MonitoringInfoConstants.Labels.NAME, metricUpdate.getKey().metricName().getName()).setLabel(MonitoringInfoConstants.Labels.PTRANSFORM, metricUpdate.getKey().stepName());
        }
        builder.setInt64Value(metricUpdate.getUpdate());
        builder.setTimestampToNow();
        return builder.build();
    }

    public Iterable<MetricsApi.MonitoringInfo> getMonitoringInfos() {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        MetricUpdates metricUpdates = this.getUpdates();
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : metricUpdates.counterUpdates()) {
            MetricsApi.MonitoringInfo mi = this.counterUpdateToMonitoringInfo(metricUpdate);
            if (mi == null) continue;
            monitoringInfos.add(mi);
        }
        return monitoringInfos;
    }

    private void commitUpdates(MetricsMap<MetricName, ? extends MetricCell<?>> cells) {
        for (MetricCell<?> cell : cells.values()) {
            cell.getDirty().afterCommit();
        }
    }

    public void commitUpdates() {
        this.commitUpdates(this.counters);
        this.commitUpdates(this.distributions);
        this.commitUpdates(this.gauges);
    }

    private <UserT extends Metric, UpdateT, CellT extends MetricCell<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractCumulatives(MetricsMap<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            Object update = Preconditions.checkNotNull(((MetricCell)cell.getValue()).getCumulative());
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create((String)this.stepName, (MetricName)cell.getKey()), update));
        }
        return updates.build();
    }

    public MetricUpdates getCumulative() {
        return MetricUpdates.create(this.extractCumulatives(this.counters), this.extractCumulatives(this.distributions), this.extractCumulatives(this.gauges));
    }

    public void update(MetricsContainerImpl other) {
        this.updateCounters(this.counters, other.counters);
        this.updateDistributions(this.distributions, other.distributions);
        this.updateGauges(this.gauges, other.gauges);
    }

    public void update(Iterable<MetricsApi.MonitoringInfo> monitoringInfos) {
        monitoringInfos.forEach(monitoringInfo -> {
            if (!monitoringInfo.hasMetric()) {
                return;
            }
            MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
            MetricsApi.Metric metric = monitoringInfo.getMetric();
            if (metric.hasCounterData()) {
                MetricsApi.CounterData counterData = metric.getCounterData();
                if (counterData.getValueCase() == MetricsApi.CounterData.ValueCase.INT64_VALUE) {
                    CounterCell counter = this.getCounter(metricName);
                    counter.inc(counterData.getInt64Value());
                } else {
                    LOG.warn("Unsupported CounterData type: {}", (Object)counterData);
                }
            } else if (metric.hasDistributionData()) {
                MetricsApi.DistributionData distributionData = metric.getDistributionData();
                if (distributionData.hasIntDistributionData()) {
                    DistributionCell distribution = this.getDistribution(metricName);
                    MetricsApi.IntDistributionData intDistributionData = distributionData.getIntDistributionData();
                    distribution.update(intDistributionData.getSum(), intDistributionData.getCount(), intDistributionData.getMin(), intDistributionData.getMax());
                } else {
                    LOG.warn("Unsupported DistributionData type: {}", (Object)distributionData);
                }
            } else if (metric.hasExtremaData()) {
                MetricsApi.ExtremaData extremaData = metric.getExtremaData();
                LOG.warn("Extrema metric unsupported: {}", (Object)extremaData);
            }
        });
    }

    private void updateCounters(MetricsMap<MetricName, CounterCell> current, MetricsMap<MetricName, CounterCell> updates) {
        for (Map.Entry<MetricName, CounterCell> counter : updates.entries()) {
            current.get(counter.getKey()).inc(counter.getValue().getCumulative());
        }
    }

    private void updateDistributions(MetricsMap<MetricName, DistributionCell> current, MetricsMap<MetricName, DistributionCell> updates) {
        for (Map.Entry<MetricName, DistributionCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    private void updateGauges(MetricsMap<MetricName, GaugeCell> current, MetricsMap<MetricName, GaugeCell> updates) {
        for (Map.Entry<MetricName, GaugeCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof MetricsContainerImpl) {
            MetricsContainerImpl metricsContainerImpl = (MetricsContainerImpl)object;
            return Objects.equals(this.stepName, metricsContainerImpl.stepName) && Objects.equals(this.counters, metricsContainerImpl.counters) && Objects.equals(this.distributions, metricsContainerImpl.distributions) && Objects.equals(this.gauges, metricsContainerImpl.gauges);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.stepName, this.counters, this.distributions, this.gauges);
    }
}

