/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.beam.fn.harness.FnHarness;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.InProcessServerFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.ServerFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.IdGenerator;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.test.InProcessManagedChannelFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedEnvironmentFactory.class);
    private final PipelineOptions options;
    private final GrpcFnServer<GrpcLoggingService> loggingServer;
    private final GrpcFnServer<FnApiControlClientPoolService> controlServer;
    private final ControlClientPool.Source clientSource;

    public static EnvironmentFactory create(PipelineOptions options, GrpcFnServer<GrpcLoggingService> loggingServer, GrpcFnServer<FnApiControlClientPoolService> controlServer, ControlClientPool.Source clientSource) {
        return new EmbeddedEnvironmentFactory(options, loggingServer, controlServer, clientSource);
    }

    private EmbeddedEnvironmentFactory(PipelineOptions options, GrpcFnServer<GrpcLoggingService> loggingServer, GrpcFnServer<FnApiControlClientPoolService> controlServer, ControlClientPool.Source clientSource) {
        this.options = options;
        this.loggingServer = loggingServer;
        this.controlServer = controlServer;
        Preconditions.checkArgument((loggingServer.getApiServiceDescriptor() != null ? 1 : 0) != 0, (String)"Logging Server cannot have a null %s", (Object)Endpoints.ApiServiceDescriptor.class.getSimpleName());
        Preconditions.checkArgument((controlServer.getApiServiceDescriptor() != null ? 1 : 0) != 0, (String)"Control Server cannot have a null %s", (Object)Endpoints.ApiServiceDescriptor.class.getSimpleName());
        this.clientSource = clientSource;
    }

    @Override
    public RemoteEnvironment createEnvironment(RunnerApi.Environment environment) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Object> fnHarness = executor.submit(() -> {
            try {
                FnHarness.main((String)"id", (PipelineOptions)this.options, (Endpoints.ApiServiceDescriptor)this.loggingServer.getApiServiceDescriptor(), (Endpoints.ApiServiceDescriptor)this.controlServer.getApiServiceDescriptor(), (ManagedChannelFactory)InProcessManagedChannelFactory.create(), (OutboundObserverFactory)OutboundObserverFactory.clientDirect());
            }
            catch (NoClassDefFoundError e) {
                LOG.error("{} while executing an in-process FnHarness. To use the {}, the 'org.apache.beam:beam-sdks-java-harness' artifact and its dependencies must be on the classpath", new Object[]{NoClassDefFoundError.class.getSimpleName(), EmbeddedEnvironmentFactory.class.getSimpleName(), e});
                throw e;
            }
            return null;
        });
        executor.submit(() -> {
            try {
                fnHarness.get();
            }
            catch (Throwable t) {
                executor.shutdownNow();
            }
        });
        InstructionRequestHandler handler = this.clientSource.take("", Duration.ofMinutes(1L));
        return RemoteEnvironment.forHandler(environment, handler);
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        private final PipelineOptions pipelineOptions;

        public Provider(PipelineOptions pipelineOptions) {
            this.pipelineOptions = pipelineOptions;
        }

        @Override
        public EnvironmentFactory createEnvironmentFactory(GrpcFnServer<FnApiControlClientPoolService> controlServer, GrpcFnServer<GrpcLoggingService> loggingServer, GrpcFnServer<ArtifactRetrievalService> retrievalServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServer, ControlClientPool clientPool, IdGenerator idGenerator) {
            return EmbeddedEnvironmentFactory.create(this.pipelineOptions, loggingServer, controlServer, clientPool.getSource());
        }

        @Override
        public ServerFactory getServerFactory() {
            return InProcessServerFactory.create();
        }
    }
}

