/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.environment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessManager.class);
    private static final boolean INHERIT_IO = LOG.isDebugEnabled();
    private static final List<ProcessManager> ALL_PROCESS_MANAGERS = new ArrayList<ProcessManager>();
    private final Map<String, Process> processes = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessManager create() {
        List<ProcessManager> list = ALL_PROCESS_MANAGERS;
        synchronized (list) {
            ProcessManager processManager = new ProcessManager();
            ALL_PROCESS_MANAGERS.add(processManager);
            return processManager;
        }
    }

    private ProcessManager() {
    }

    RunningProcess startProcess(String id, String command, List<String> args) throws IOException {
        return this.startProcess(id, command, args, Collections.emptyMap());
    }

    public RunningProcess startProcess(String id, String command, List<String> args, Map<String, String> env) throws IOException {
        Preconditions.checkNotNull((Object)id, (Object)"Process id must not be null");
        Preconditions.checkNotNull((Object)command, (Object)"Command must not be null");
        Preconditions.checkNotNull(args, (Object)"Process args must not be null");
        Preconditions.checkNotNull(env, (Object)"Environment map must not be null");
        ProcessBuilder pb = new ProcessBuilder((List<String>)ImmutableList.builder().add((Object)command).addAll(args).build());
        pb.environment().putAll(env);
        if (INHERIT_IO) {
            LOG.debug("==> DEBUG enabled: Inheriting stdout/stderr of process (adjustable in ProcessManager)");
            pb.inheritIO();
        } else {
            pb.redirectErrorStream(true);
            if (System.getProperty("os.name", "").startsWith("Windows")) {
                pb.redirectOutput(new File("nul"));
            } else {
                pb.redirectOutput(new File("/dev/null"));
            }
        }
        LOG.debug("Attempting to start process with command: {}", pb.command());
        Process newProcess = pb.start();
        Process oldProcess = this.processes.put(id, newProcess);
        if (oldProcess != null) {
            this.stopProcess(id, oldProcess);
            this.stopProcess(id, newProcess);
            throw new IllegalStateException("There was already a process running with id " + id);
        }
        return new RunningProcess(newProcess);
    }

    public void stopProcess(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"Process id must not be null");
        Process process = (Process)Preconditions.checkNotNull((Object)this.processes.remove(id), (Object)("Process for id does not exist: " + id));
        this.stopProcess(id, process);
    }

    private void stopProcess(String id, Process process) {
        if (process.isAlive()) {
            LOG.debug("Attempting to stop process with id {}", (Object)id);
            process.destroy();
            long maxTimeToWait = 2000L;
            if (ProcessManager.waitForProcessToDie(process, maxTimeToWait)) {
                LOG.debug("Process for worker {} shut down gracefully.", (Object)id);
            } else {
                LOG.info("Process for worker {} still running. Killing.", (Object)id);
                process.destroyForcibly();
                if (ProcessManager.waitForProcessToDie(process, maxTimeToWait)) {
                    LOG.debug("Process for worker {} killed.", (Object)id);
                } else {
                    LOG.warn("Process for worker {} could not be killed.", (Object)id);
                }
            }
        }
    }

    private static boolean waitForProcessToDie(Process process, long maxWaitTimeMillis) {
        long startTime = System.currentTimeMillis();
        while (process.isAlive() && System.currentTimeMillis() - startTime < maxWaitTimeMillis) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting on process", e);
            }
        }
        return !process.isAlive();
    }

    private void stopAllProcesses() {
        this.processes.forEach((id, process) -> process.destroy());
    }

    private void killAllProcesses() {
        this.processes.forEach((id, process) -> process.destroyForcibly());
    }

    static {
        Runtime.getRuntime().addShutdownHook(ShutdownHook.create());
    }

    private static class ShutdownHook
    extends Thread {
        private static ShutdownHook create() {
            return new ShutdownHook();
        }

        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
        public void run() {
            List list = ALL_PROCESS_MANAGERS;
            synchronized (list) {
                ALL_PROCESS_MANAGERS.forEach(rec$ -> ((ProcessManager)rec$).stopAllProcesses());
                for (ProcessManager pm : ALL_PROCESS_MANAGERS) {
                    if (!pm.processes.values().stream().anyMatch(Process::isAlive)) continue;
                    try {
                        Thread.sleep(200L);
                        break;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
                ALL_PROCESS_MANAGERS.forEach(rec$ -> ((ProcessManager)rec$).killAllProcesses());
            }
        }
    }

    static class RunningProcess {
        private Process process;

        RunningProcess(Process process) {
            this.process = process;
        }

        void isAliveOrThrow() throws IllegalStateException {
            if (!this.process.isAlive()) {
                throw new IllegalStateException("Process died with exit code " + this.process.exitValue());
            }
        }

        @VisibleForTesting
        Process getUnderlyingProcess() {
            return this.process;
        }
    }
}

