/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable.artifact;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.direct.portable.artifact.LocalArtifactStagingLocation;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.stub.StreamObserver;

public class LocalFileSystemArtifactRetrievalService
extends ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceImplBase
implements ArtifactRetrievalService {
    private static final int DEFAULT_CHUNK_SIZE = 0x200000;
    private final LocalArtifactStagingLocation location;
    private final ArtifactApi.Manifest manifest;

    public static LocalFileSystemArtifactRetrievalService forRootDirectory(File base) {
        return new LocalFileSystemArtifactRetrievalService(base);
    }

    private LocalFileSystemArtifactRetrievalService(File rootDirectory) {
        this.location = LocalArtifactStagingLocation.forExistingDirectory(rootDirectory);
        try (FileInputStream manifestStream = new FileInputStream(this.location.getManifestFile());){
            this.manifest = ArtifactApi.Manifest.parseFrom((InputStream)manifestStream);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("No %s in root directory %s", ArtifactApi.Manifest.class.getSimpleName(), rootDirectory), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void getManifest(ArtifactApi.GetManifestRequest request, StreamObserver<ArtifactApi.GetManifestResponse> responseObserver) {
        try {
            responseObserver.onNext((Object)ArtifactApi.GetManifestResponse.newBuilder().setManifest(this.manifest).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
        }
    }

    private ByteBuffer getArtifact(String name) throws IOException {
        File artifact = this.location.getArtifactFile(name);
        if (!artifact.exists()) {
            throw new FileNotFoundException(String.format("No such artifact %s", name));
        }
        FileChannel input = new FileInputStream(artifact).getChannel();
        return input.map(FileChannel.MapMode.READ_ONLY, 0L, input.size());
    }

    public void getArtifact(ArtifactApi.GetArtifactRequest request, StreamObserver<ArtifactApi.ArtifactChunk> responseObserver) {
        try {
            ByteBuffer artifact = this.getArtifact(request.getName());
            do {
                responseObserver.onNext((Object)ArtifactApi.ArtifactChunk.newBuilder().setData(ByteString.copyFrom((ByteBuffer)artifact, (int)Math.min(artifact.remaining(), 0x200000))).build());
            } while (artifact.hasRemaining());
            responseObserver.onCompleted();
        }
        catch (FileNotFoundException e) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(String.format("No such artifact %s", request.getName())).withCause((Throwable)e).asException());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(String.format("Could not retrieve artifact with name %s", request.getName())).withCause((Throwable)e).asException());
        }
    }

    @Override
    public void close() throws Exception {
    }
}

