/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class SchemaTranslation {
    private static final String URN_BEAM_LOGICAL_DATETIME = "beam:fieldtype:datetime";
    private static final String URN_BEAM_LOGICAL_DECIMAL = "beam:fieldtype:decimal";

    public static SchemaApi.Schema toProto(Schema schema) {
        String uuid = schema.getUUID() != null ? schema.getUUID().toString() : "";
        SchemaApi.Schema.Builder builder = SchemaApi.Schema.newBuilder().setId(uuid);
        for (Schema.Field field : schema.getFields()) {
            SchemaApi.Field protoField = SchemaTranslation.toProto(field, schema.indexOf(field.getName()), (Integer)schema.getEncodingPositions().get(field.getName()));
            builder.addFields(protoField);
        }
        return builder.build();
    }

    private static SchemaApi.Field toProto(Schema.Field field, int fieldId, int position) {
        return SchemaApi.Field.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setType(SchemaTranslation.toProto(field.getType())).setId(fieldId).setEncodingPosition(position).build();
    }

    private static SchemaApi.FieldType toProto(Schema.FieldType fieldType) {
        SchemaApi.FieldType.Builder builder = SchemaApi.FieldType.newBuilder();
        switch (fieldType.getTypeName()) {
            case ROW: {
                builder.setRowType(SchemaApi.RowType.newBuilder().setSchema(SchemaTranslation.toProto(fieldType.getRowSchema())));
                break;
            }
            case ARRAY: {
                builder.setArrayType(SchemaApi.ArrayType.newBuilder().setElementType(SchemaTranslation.toProto(fieldType.getCollectionElementType())));
                break;
            }
            case MAP: {
                builder.setMapType(SchemaApi.MapType.newBuilder().setKeyType(SchemaTranslation.toProto(fieldType.getMapKeyType())).setValueType(SchemaTranslation.toProto(fieldType.getMapValueType())).build());
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(logicalType.getIdentifier()).setArgs(logicalType.getArgument()).setRepresentation(SchemaTranslation.toProto(logicalType.getBaseType())).build());
                break;
            }
            case DATETIME: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DATETIME).setRepresentation(SchemaTranslation.toProto(Schema.FieldType.INT64)).build());
                break;
            }
            case DECIMAL: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DECIMAL).setRepresentation(SchemaTranslation.toProto(Schema.FieldType.BYTES)).build());
                break;
            }
            case BYTE: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTE);
                break;
            }
            case INT16: {
                builder.setAtomicType(SchemaApi.AtomicType.INT16);
                break;
            }
            case INT32: {
                builder.setAtomicType(SchemaApi.AtomicType.INT32);
                break;
            }
            case INT64: {
                builder.setAtomicType(SchemaApi.AtomicType.INT64);
                break;
            }
            case FLOAT: {
                builder.setAtomicType(SchemaApi.AtomicType.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setAtomicType(SchemaApi.AtomicType.DOUBLE);
                break;
            }
            case STRING: {
                builder.setAtomicType(SchemaApi.AtomicType.STRING);
                break;
            }
            case BOOLEAN: {
                builder.setAtomicType(SchemaApi.AtomicType.BOOLEAN);
                break;
            }
            case BYTES: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTES);
            }
        }
        builder.setNullable(fieldType.getNullable().booleanValue());
        return builder.build();
    }

    public static Schema fromProto(SchemaApi.Schema protoSchema) {
        Schema.Builder builder = Schema.builder();
        HashMap encodingLocationMap = Maps.newHashMap();
        for (SchemaApi.Field protoField : protoSchema.getFieldsList()) {
            Schema.Field field = SchemaTranslation.fieldFromProto(protoField);
            builder.addField(field);
            encodingLocationMap.put(protoField.getName(), protoField.getEncodingPosition());
        }
        Schema schema = builder.build();
        schema.setEncodingPositions((Map)encodingLocationMap);
        if (!protoSchema.getId().isEmpty()) {
            schema.setUUID(UUID.fromString(protoSchema.getId()));
        }
        return schema;
    }

    private static Schema.Field fieldFromProto(SchemaApi.Field protoField) {
        return Schema.Field.of((String)protoField.getName(), (Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoField.getType())).withDescription(protoField.getDescription());
    }

    private static Schema.FieldType fieldTypeFromProto(SchemaApi.FieldType protoFieldType) {
        Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProtoWithoutNullable(protoFieldType);
        if (protoFieldType.getNullable()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }

    private static Schema.FieldType fieldTypeFromProtoWithoutNullable(SchemaApi.FieldType protoFieldType) {
        switch (protoFieldType.getTypeInfoCase()) {
            case ATOMIC_TYPE: {
                switch (protoFieldType.getAtomicType()) {
                    case BYTE: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.BYTE);
                    }
                    case INT16: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.INT16);
                    }
                    case INT32: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.INT32);
                    }
                    case INT64: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.INT64);
                    }
                    case FLOAT: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.FLOAT);
                    }
                    case DOUBLE: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.DOUBLE);
                    }
                    case STRING: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.STRING);
                    }
                    case BOOLEAN: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.BOOLEAN);
                    }
                    case BYTES: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.BYTES);
                    }
                    case UNSPECIFIED: {
                        throw new IllegalArgumentException("Encountered UNSPECIFIED AtomicType");
                    }
                }
                throw new IllegalArgumentException("Encountered unknown AtomicType: " + protoFieldType.getAtomicType());
            }
            case ROW_TYPE: {
                return Schema.FieldType.row((Schema)SchemaTranslation.fromProto(protoFieldType.getRowType().getSchema()));
            }
            case ARRAY_TYPE: {
                return Schema.FieldType.array((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getArrayType().getElementType()));
            }
            case MAP_TYPE: {
                return Schema.FieldType.map((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getKeyType()), (Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getValueType()));
            }
            case LOGICAL_TYPE: {
                String urn = protoFieldType.getLogicalType().getUrn();
                if (urn.equals(URN_BEAM_LOGICAL_DATETIME)) {
                    return Schema.FieldType.DATETIME;
                }
                if (urn.equals(URN_BEAM_LOGICAL_DECIMAL)) {
                    return Schema.FieldType.DECIMAL;
                }
                throw new IllegalArgumentException("Decoding logical types is not yet supported.");
            }
        }
        throw new IllegalArgumentException("Unexpected type_info: " + protoFieldType.getTypeInfoCase());
    }
}

