/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.expansion;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.beam.repackaged.direct_java.runners.core.construction.expansion.ExpansionService;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.netty.NettyServerBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class ExpansionServer
implements AutoCloseable {
    private final String host;
    private final int port;
    private final Server server;
    private final ExpansionService service;

    public static ExpansionServer create(ExpansionService service, String host, int port) throws IOException {
        return new ExpansionServer(service, host, port);
    }

    private ExpansionServer(ExpansionService service, String host, int port) throws IOException {
        this.service = (ExpansionService)Preconditions.checkNotNull((Object)service);
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.server = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(host, port)).addService((BindableService)service)).build().start();
        this.port = this.server.getPort();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void close() throws Exception {
        try {
            this.server.shutdown();
            this.service.close();
            this.server.awaitTermination(60L, TimeUnit.SECONDS);
        }
        finally {
            this.server.shutdownNow();
            this.server.awaitTermination();
        }
    }
}

