/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.joda.time.DateTimeUtils;

public class ExecutionStateSampler {
    private final ConcurrentSkipListSet<ExecutionStateTracker> activeTrackers = new ConcurrentSkipListSet();
    private static final DateTimeUtils.MillisProvider SYSTEM_MILLIS_PROVIDER = System::currentTimeMillis;
    private static final ExecutionStateSampler INSTANCE = new ExecutionStateSampler(SYSTEM_MILLIS_PROVIDER);
    private final DateTimeUtils.MillisProvider clock;
    @VisibleForTesting
    volatile long lastSampleTimeMillis;
    private static final long PERIOD_MS = 200L;
    @Nullable
    private Future<Void> executionSamplerFuture = null;

    private ExecutionStateSampler(DateTimeUtils.MillisProvider clock) {
        this.clock = clock;
    }

    public static ExecutionStateSampler instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    public static ExecutionStateSampler newForTest() {
        return new ExecutionStateSampler(SYSTEM_MILLIS_PROVIDER);
    }

    @VisibleForTesting
    public static ExecutionStateSampler newForTest(DateTimeUtils.MillisProvider clock) {
        return new ExecutionStateSampler((DateTimeUtils.MillisProvider)Preconditions.checkNotNull((Object)clock));
    }

    public void start() {
        this.start(Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("state-sampler-%d").build()));
    }

    @VisibleForTesting
    synchronized void start(ExecutorService executor) {
        if (this.executionSamplerFuture != null) {
            return;
        }
        this.executionSamplerFuture = executor.submit(() -> {
            this.lastSampleTimeMillis = this.clock.getMillis();
            long targetTimeMillis = this.lastSampleTimeMillis + 200L;
            while (!Thread.interrupted()) {
                long currentTimeMillis = this.clock.getMillis();
                long difference = targetTimeMillis - currentTimeMillis;
                if (difference > 0L) {
                    try {
                        Thread.sleep(difference);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                this.doSampling(currentTimeMillis - this.lastSampleTimeMillis);
                this.lastSampleTimeMillis = currentTimeMillis;
                targetTimeMillis = this.lastSampleTimeMillis + 200L;
            }
            return null;
        });
    }

    public synchronized void stop() {
        if (this.executionSamplerFuture == null) {
            return;
        }
        this.executionSamplerFuture.cancel(true);
        try {
            this.executionSamplerFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to stop state sampling after waiting 5 sampling periods.", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception in state sampler", e);
        }
        finally {
            this.executionSamplerFuture = null;
        }
    }

    void addTracker(ExecutionStateTracker tracker) {
        this.activeTrackers.add(tracker);
    }

    synchronized void removeTracker(ExecutionStateTracker tracker) {
        this.activeTrackers.remove(tracker);
        long millisSinceLastSample = this.clock.getMillis() - this.lastSampleTimeMillis;
        if (millisSinceLastSample > 0L) {
            tracker.takeSample(millisSinceLastSample);
        }
    }

    @VisibleForTesting
    public synchronized void doSampling(long millisSinceLastSample) {
        for (ExecutionStateTracker tracker : this.activeTrackers) {
            tracker.takeSample(millisSinceLastSample);
        }
    }
}

