/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.environment;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnExternalWorkerPoolGrpc;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.GrpcFnServer;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.repackaged.direct_java.sdk.fn.IdGenerator;
import org.apache.beam.repackaged.direct_java.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.Channel;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalEnvironmentFactory.class);
    private final GrpcFnServer<FnApiControlClientPoolService> controlServiceServer;
    private final GrpcFnServer<GrpcLoggingService> loggingServiceServer;
    private final GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer;
    private final GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer;
    private final IdGenerator idGenerator;
    private final ControlClientPool.Source clientSource;

    public static ExternalEnvironmentFactory create(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool.Source clientSource, IdGenerator idGenerator) {
        return new ExternalEnvironmentFactory(controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, idGenerator, clientSource);
    }

    private ExternalEnvironmentFactory(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, IdGenerator idGenerator, ControlClientPool.Source clientSource) {
        this.controlServiceServer = controlServiceServer;
        this.loggingServiceServer = loggingServiceServer;
        this.retrievalServiceServer = retrievalServiceServer;
        this.provisioningServiceServer = provisioningServiceServer;
        this.idGenerator = idGenerator;
        this.clientSource = clientSource;
    }

    @Override
    public RemoteEnvironment createEnvironment(final RunnerApi.Environment environment) throws Exception {
        Preconditions.checkState((boolean)environment.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL)), (Object)"The passed environment does not contain an ExternalPayload.");
        RunnerApi.ExternalPayload externalPayload = RunnerApi.ExternalPayload.parseFrom((ByteString)environment.getPayload());
        String workerId = this.idGenerator.getId();
        BeamFnApi.NotifyRunnerAvailableRequest notifyRunnerAvailableRequest = BeamFnApi.NotifyRunnerAvailableRequest.newBuilder().setWorkerId(workerId).setControlEndpoint(this.controlServiceServer.getApiServiceDescriptor()).setLoggingEndpoint(this.loggingServiceServer.getApiServiceDescriptor()).setArtifactEndpoint(this.retrievalServiceServer.getApiServiceDescriptor()).setProvisionEndpoint(this.provisioningServiceServer.getApiServiceDescriptor()).putAllParams(externalPayload.getParamsMap()).build();
        LOG.debug("Requesting worker ID {}", (Object)workerId);
        BeamFnApi.NotifyRunnerAvailableResponse notifyRunnerAvailableResponse = BeamFnExternalWorkerPoolGrpc.newBlockingStub((Channel)ManagedChannelFactory.createDefault().forDescriptor(externalPayload.getEndpoint())).notifyRunnerAvailable(notifyRunnerAvailableRequest);
        if (!notifyRunnerAvailableResponse.getError().isEmpty()) {
            throw new RuntimeException(notifyRunnerAvailableResponse.getError());
        }
        InstructionRequestHandler instructionHandler = null;
        while (instructionHandler == null) {
            try {
                instructionHandler = this.clientSource.take(workerId, Duration.ofMinutes(2L));
            }
            catch (TimeoutException timeoutEx) {
                LOG.info("Still waiting for startup of environment from {} for worker id {}", (Object)externalPayload.getEndpoint().getUrl(), (Object)workerId);
            }
            catch (InterruptedException interruptEx) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptEx);
            }
        }
        final InstructionRequestHandler finalInstructionHandler = instructionHandler;
        return new RemoteEnvironment(){

            @Override
            public RunnerApi.Environment getEnvironment() {
                return environment;
            }

            @Override
            public InstructionRequestHandler getInstructionRequestHandler() {
                return finalInstructionHandler;
            }
        };
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        @Override
        public EnvironmentFactory createEnvironmentFactory(GrpcFnServer<FnApiControlClientPoolService> controlServiceServer, GrpcFnServer<GrpcLoggingService> loggingServiceServer, GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer, GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer, ControlClientPool clientPool, IdGenerator idGenerator) {
            return ExternalEnvironmentFactory.create(controlServiceServer, loggingServiceServer, retrievalServiceServer, provisioningServiceServer, clientPool.getSource(), idGenerator);
        }
    }
}

