/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.wire;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SyntheticComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class WireCoders {
    public static String addSdkWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components.Builder components) {
        return WireCoders.addWireCoder(pCollectionNode, components, false);
    }

    public static String addRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components.Builder components) {
        return WireCoders.addWireCoder(pCollectionNode, components, true);
    }

    public static <T> Coder<WindowedValue<T>> instantiateRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components) throws IOException {
        RunnerApi.Components.Builder builder = components.toBuilder();
        String protoCoderId = WireCoders.addRunnerWireCoder(pCollectionNode, builder);
        Coder<?> javaCoder = RehydratedComponents.forComponents(builder.build()).getCoder(protoCoderId);
        Preconditions.checkArgument((boolean)(javaCoder instanceof WindowedValue.FullWindowedValueCoder), (String)"Unexpected Deserialized %s type, expected %s, got %s", (Object)RunnerApi.Coder.class.getSimpleName(), (Object)WindowedValue.FullWindowedValueCoder.class.getSimpleName(), javaCoder.getClass());
        return javaCoder;
    }

    private static String addWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components.Builder components, boolean useByteArrayCoder) {
        String elementCoderId = pCollectionNode.getPCollection().getCoderId();
        String windowingStrategyId = pCollectionNode.getPCollection().getWindowingStrategyId();
        String windowCoderId = components.getWindowingStrategiesOrThrow(windowingStrategyId).getWindowCoderId();
        RunnerApi.Coder windowedValueCoder = ModelCoders.windowedValueCoder(elementCoderId, windowCoderId);
        String windowedValueId = SyntheticComponents.uniqueId(String.format("fn/wire/%s", pCollectionNode.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsCoders(arg_0));
        components.putCoders(windowedValueId, windowedValueCoder);
        return LengthPrefixUnknownCoders.addLengthPrefixedCoder(windowedValueId, components, useByteArrayCoder);
    }

    private WireCoders() {
    }
}

