/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunners;
import org.apache.beam.repackaged.direct_java.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.SimplePushbackSideInputDoFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class ParDoEvaluator<InputT>
implements TransformEvaluator<InputT> {
    private final PushbackSideInputDoFnRunner<InputT, ?> fnRunner;
    private final AppliedPTransform<?, ?, ?> transform;
    private final BundleOutputManager outputManager;
    private final DirectExecutionContext.DirectStepContext stepContext;
    private final ImmutableList.Builder<WindowedValue<InputT>> unprocessedElements;

    public static <InputT, OutputT> DoFnRunnerFactory<InputT, OutputT> defaultRunnerFactory() {
        return (options, fn, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, schemaCoder, outputCoders, windowingStrategy, doFnSchemaInformation) -> {
            DoFnRunner underlying = DoFnRunners.simpleRunner(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, schemaCoder, outputCoders, windowingStrategy, doFnSchemaInformation);
            return SimplePushbackSideInputDoFnRunner.create(underlying, sideInputs, sideInputReader);
        };
    }

    public static <InputT, OutputT> ParDoEvaluator<InputT> create(EvaluationContext evaluationContext, PipelineOptions options, DirectExecutionContext.DirectStepContext stepContext, AppliedPTransform<?, ?, ?> application, Coder<InputT> inputCoder, WindowingStrategy<?, ? extends BoundedWindow> windowingStrategy, DoFn<InputT, OutputT> fn, StructuralKey<?> key, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, Map<TupleTag<?>, PCollection<?>> outputs, DoFnSchemaInformation doFnSchemaInformation, DoFnRunnerFactory<InputT, OutputT> runnerFactory) {
        BundleOutputManager outputManager = ParDoEvaluator.createOutputManager(evaluationContext, key, outputs);
        ReadyCheckingSideInputReader sideInputReader = evaluationContext.createSideInputReader(sideInputs);
        Map<TupleTag<?>, Coder<?>> outputCoders = outputs.entrySet().stream().collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
        PushbackSideInputDoFnRunner<InputT, OutputT> runner = runnerFactory.createRunner(options, fn, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation);
        return ParDoEvaluator.create(runner, stepContext, application, outputManager);
    }

    public static <InputT, OutputT> ParDoEvaluator<InputT> create(PushbackSideInputDoFnRunner<InputT, OutputT> runner, DirectExecutionContext.DirectStepContext stepContext, AppliedPTransform<?, ?, ?> application, BundleOutputManager outputManager) {
        return new ParDoEvaluator<InputT>(runner, application, outputManager, stepContext);
    }

    static BundleOutputManager createOutputManager(EvaluationContext evaluationContext, StructuralKey<?> key, Map<TupleTag<?>, PCollection<?>> outputs) {
        HashMap outputBundles = new HashMap();
        for (Map.Entry<TupleTag<?>, PCollection<?>> outputEntry : outputs.entrySet()) {
            if (evaluationContext.isKeyed((PValue)outputEntry.getValue())) {
                outputBundles.put(outputEntry.getKey(), evaluationContext.createKeyedBundle(key, outputEntry.getValue()));
                continue;
            }
            outputBundles.put(outputEntry.getKey(), evaluationContext.createBundle(outputEntry.getValue()));
        }
        return BundleOutputManager.create(outputBundles);
    }

    private ParDoEvaluator(PushbackSideInputDoFnRunner<InputT, ?> fnRunner, AppliedPTransform<?, ?, ?> transform, BundleOutputManager outputManager, DirectExecutionContext.DirectStepContext stepContext) {
        this.fnRunner = fnRunner;
        this.transform = transform;
        this.outputManager = outputManager;
        this.stepContext = stepContext;
        this.unprocessedElements = ImmutableList.builder();
        try {
            fnRunner.startBundle();
        }
        catch (Exception e) {
            throw UserCodeException.wrap((Throwable)e);
        }
    }

    public PushbackSideInputDoFnRunner<InputT, ?> getFnRunner() {
        return this.fnRunner;
    }

    public DirectExecutionContext.DirectStepContext getStepContext() {
        return this.stepContext;
    }

    public BundleOutputManager getOutputManager() {
        return this.outputManager;
    }

    @Override
    public void processElement(WindowedValue<InputT> element) {
        try {
            Iterable<WindowedValue<InputT>> unprocessed = this.fnRunner.processElementInReadyWindows(element);
            this.unprocessedElements.addAll(unprocessed);
        }
        catch (Exception e) {
            throw UserCodeException.wrap((Throwable)e);
        }
    }

    public void onTimer(TimerInternals.TimerData timer, BoundedWindow window) {
        try {
            this.fnRunner.onTimer(timer.getTimerId(), window, timer.getTimestamp(), timer.getDomain());
        }
        catch (Exception e) {
            throw UserCodeException.wrap((Throwable)e);
        }
    }

    @Override
    public TransformResult<InputT> finishBundle() {
        try {
            this.fnRunner.finishBundle();
        }
        catch (Exception e) {
            throw UserCodeException.wrap((Throwable)e);
        }
        CopyOnAccessInMemoryStateInternals state = this.stepContext.commitState();
        StepTransformResult.Builder resultBuilder = state != null ? StepTransformResult.withHold(this.transform, state.getEarliestWatermarkHold()).withState(state) : StepTransformResult.withoutHold(this.transform);
        return resultBuilder.addOutput(this.outputManager.bundles.values()).withTimerUpdate(this.stepContext.getTimerUpdate()).addUnprocessedElements(this.unprocessedElements.build()).build();
    }

    static class BundleOutputManager
    implements DoFnRunners.OutputManager {
        private final Map<TupleTag<?>, UncommittedBundle<?>> bundles;

        public static BundleOutputManager create(Map<TupleTag<?>, UncommittedBundle<?>> outputBundles) {
            return new BundleOutputManager(outputBundles);
        }

        private BundleOutputManager(Map<TupleTag<?>, UncommittedBundle<?>> bundles) {
            this.bundles = bundles;
        }

        @Override
        public <T> void output(TupleTag<T> tag, WindowedValue<T> output) {
            Preconditions.checkArgument((boolean)this.bundles.containsKey(tag), (String)"Unknown output tag %s", tag);
            this.bundles.get(tag).add(output);
        }
    }

    public static interface DoFnRunnerFactory<InputT, OutputT> {
        public PushbackSideInputDoFnRunner<InputT, OutputT> createRunner(PipelineOptions var1, DoFn<InputT, OutputT> var2, List<PCollectionView<?>> var3, ReadyCheckingSideInputReader var4, DoFnRunners.OutputManager var5, TupleTag<OutputT> var6, List<TupleTag<?>> var7, DirectExecutionContext.DirectStepContext var8, @Nullable Coder<InputT> var9, Map<TupleTag<?>, Coder<?>> var10, WindowingStrategy<?, ? extends BoundedWindow> var11, DoFnSchemaInformation var12);
    }
}

