/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.beam.model.expansion.v1.ExpansionApi;
import org.apache.beam.model.expansion.v1.ExpansionServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ExpansionServiceClient;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ExpansionServiceClientFactory;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.ManagedChannel;

public class DefaultExpansionServiceClientFactory
implements ExpansionServiceClientFactory {
    private Map<Endpoints.ApiServiceDescriptor, ExpansionServiceClient> expansionServiceMap = new ConcurrentHashMap<Endpoints.ApiServiceDescriptor, ExpansionServiceClient>();
    private Function<Endpoints.ApiServiceDescriptor, ManagedChannel> channelFactory;

    DefaultExpansionServiceClientFactory(Function<Endpoints.ApiServiceDescriptor, ManagedChannel> channelFactory) {
        this.channelFactory = channelFactory;
    }

    @Override
    public void close() throws Exception {
        Iterator<ExpansionServiceClient> iterator = this.expansionServiceMap.values().iterator();
        while (iterator.hasNext()) {
            ExpansionServiceClient client;
            ExpansionServiceClient closer = client = iterator.next();
            Throwable throwable = null;
            if (closer == null) continue;
            if (throwable != null) {
                try {
                    closer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                continue;
            }
            closer.close();
        }
    }

    @Override
    public ExpansionServiceClient getExpansionServiceClient(final Endpoints.ApiServiceDescriptor endpoint) {
        return this.expansionServiceMap.computeIfAbsent(endpoint, e -> new ExpansionServiceClient(){
            private final ManagedChannel channel;
            private final ExpansionServiceGrpc.ExpansionServiceBlockingStub service;
            {
                this.channel = (ManagedChannel)DefaultExpansionServiceClientFactory.this.channelFactory.apply(endpoint);
                this.service = ExpansionServiceGrpc.newBlockingStub((Channel)this.channel);
            }

            @Override
            public ExpansionApi.ExpansionResponse expand(ExpansionApi.ExpansionRequest request) {
                return this.service.expand(request);
            }

            @Override
            public void close() throws Exception {
                this.channel.shutdown();
            }
        });
    }
}

