/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class SchemaTranslation {
    private static final String URN_BEAM_LOGICAL_DATETIME = "beam:logical_type:datetime:v1";
    private static final String URN_BEAM_LOGICAL_DECIMAL = "beam:logical_type:decimal:v1";
    private static final String URN_BEAM_LOGICAL_JAVASDK = "beam:logical_type:javasdk:v1";

    public static SchemaApi.Schema schemaToProto(Schema schema) {
        String uuid = schema.getUUID() != null ? schema.getUUID().toString() : "";
        SchemaApi.Schema.Builder builder = SchemaApi.Schema.newBuilder().setId(uuid);
        for (Schema.Field field : schema.getFields()) {
            SchemaApi.Field protoField = SchemaTranslation.fieldToProto(field, schema.indexOf(field.getName()), (Integer)schema.getEncodingPositions().get(field.getName()));
            builder.addFields(protoField);
        }
        return builder.build();
    }

    private static SchemaApi.Field fieldToProto(Schema.Field field, int fieldId, int position) {
        return SchemaApi.Field.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setType(SchemaTranslation.fieldTypeToProto(field.getType())).setId(fieldId).setEncodingPosition(position).build();
    }

    private static SchemaApi.FieldType fieldTypeToProto(Schema.FieldType fieldType) {
        SchemaApi.FieldType.Builder builder = SchemaApi.FieldType.newBuilder();
        switch (fieldType.getTypeName()) {
            case ROW: {
                builder.setRowType(SchemaApi.RowType.newBuilder().setSchema(SchemaTranslation.schemaToProto(fieldType.getRowSchema())));
                break;
            }
            case ARRAY: {
                builder.setArrayType(SchemaApi.ArrayType.newBuilder().setElementType(SchemaTranslation.fieldTypeToProto(fieldType.getCollectionElementType())));
                break;
            }
            case ITERABLE: {
                builder.setIterableType(SchemaApi.IterableType.newBuilder().setElementType(SchemaTranslation.fieldTypeToProto(fieldType.getCollectionElementType())));
                break;
            }
            case MAP: {
                builder.setMapType(SchemaApi.MapType.newBuilder().setKeyType(SchemaTranslation.fieldTypeToProto(fieldType.getMapKeyType())).setValueType(SchemaTranslation.fieldTypeToProto(fieldType.getMapValueType())).build());
                break;
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_JAVASDK).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)logicalType))).setRepresentation(SchemaTranslation.fieldTypeToProto(logicalType.getBaseType())).build());
                break;
            }
            case DATETIME: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DATETIME).setRepresentation(SchemaTranslation.fieldTypeToProto(Schema.FieldType.INT64)).build());
                break;
            }
            case DECIMAL: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DECIMAL).setRepresentation(SchemaTranslation.fieldTypeToProto(Schema.FieldType.BYTES)).build());
                break;
            }
            case BYTE: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTE);
                break;
            }
            case INT16: {
                builder.setAtomicType(SchemaApi.AtomicType.INT16);
                break;
            }
            case INT32: {
                builder.setAtomicType(SchemaApi.AtomicType.INT32);
                break;
            }
            case INT64: {
                builder.setAtomicType(SchemaApi.AtomicType.INT64);
                break;
            }
            case FLOAT: {
                builder.setAtomicType(SchemaApi.AtomicType.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setAtomicType(SchemaApi.AtomicType.DOUBLE);
                break;
            }
            case STRING: {
                builder.setAtomicType(SchemaApi.AtomicType.STRING);
                break;
            }
            case BOOLEAN: {
                builder.setAtomicType(SchemaApi.AtomicType.BOOLEAN);
                break;
            }
            case BYTES: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTES);
            }
        }
        builder.setNullable(fieldType.getNullable().booleanValue());
        return builder.build();
    }

    public static Schema fromProto(SchemaApi.Schema protoSchema) {
        Schema.Builder builder = Schema.builder();
        HashMap encodingLocationMap = Maps.newHashMap();
        for (SchemaApi.Field protoField : protoSchema.getFieldsList()) {
            Schema.Field field = SchemaTranslation.fieldFromProto(protoField);
            builder.addField(field);
            encodingLocationMap.put(protoField.getName(), protoField.getEncodingPosition());
        }
        Schema schema = builder.build();
        schema.setEncodingPositions((Map)encodingLocationMap);
        if (!protoSchema.getId().isEmpty()) {
            schema.setUUID(UUID.fromString(protoSchema.getId()));
        }
        return schema;
    }

    private static Schema.Field fieldFromProto(SchemaApi.Field protoField) {
        return Schema.Field.of((String)protoField.getName(), (Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoField.getType())).withDescription(protoField.getDescription());
    }

    private static Schema.FieldType fieldTypeFromProto(SchemaApi.FieldType protoFieldType) {
        Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProtoWithoutNullable(protoFieldType);
        if (protoFieldType.getNullable()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }

    private static Schema.FieldType fieldTypeFromProtoWithoutNullable(SchemaApi.FieldType protoFieldType) {
        switch (protoFieldType.getTypeInfoCase()) {
            case ATOMIC_TYPE: {
                switch (protoFieldType.getAtomicType()) {
                    case BYTE: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.BYTE);
                    }
                    case INT16: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.INT16);
                    }
                    case INT32: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.INT32);
                    }
                    case INT64: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.INT64);
                    }
                    case FLOAT: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.FLOAT);
                    }
                    case DOUBLE: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.DOUBLE);
                    }
                    case STRING: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.STRING);
                    }
                    case BOOLEAN: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.BOOLEAN);
                    }
                    case BYTES: {
                        return Schema.FieldType.of((Schema.TypeName)Schema.TypeName.BYTES);
                    }
                    case UNSPECIFIED: {
                        throw new IllegalArgumentException("Encountered UNSPECIFIED AtomicType");
                    }
                }
                throw new IllegalArgumentException("Encountered unknown AtomicType: " + protoFieldType.getAtomicType());
            }
            case ROW_TYPE: {
                return Schema.FieldType.row((Schema)SchemaTranslation.fromProto(protoFieldType.getRowType().getSchema()));
            }
            case ARRAY_TYPE: {
                return Schema.FieldType.array((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getArrayType().getElementType()));
            }
            case ITERABLE_TYPE: {
                return Schema.FieldType.iterable((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getIterableType().getElementType()));
            }
            case MAP_TYPE: {
                return Schema.FieldType.map((Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getKeyType()), (Schema.FieldType)SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getValueType()));
            }
            case LOGICAL_TYPE: {
                String urn = protoFieldType.getLogicalType().getUrn();
                if (urn.equals(URN_BEAM_LOGICAL_DATETIME)) {
                    return Schema.FieldType.DATETIME;
                }
                if (urn.equals(URN_BEAM_LOGICAL_DECIMAL)) {
                    return Schema.FieldType.DECIMAL;
                }
                if (urn.equals(URN_BEAM_LOGICAL_JAVASDK)) {
                    return Schema.FieldType.logicalType((Schema.LogicalType)((Schema.LogicalType)SerializableUtils.deserializeFromByteArray((byte[])protoFieldType.getLogicalType().getPayload().toByteArray(), (String)"logicalType")));
                }
                throw new IllegalArgumentException("Encountered unsupported logical type URN: " + urn);
            }
        }
        throw new IllegalArgumentException("Unexpected type_info: " + protoFieldType.getTypeInfoCase());
    }
}

