/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SimpleExecutionState;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;

public class SimpleStateRegistry {
    private List<SimpleExecutionState> executionStates = new ArrayList<SimpleExecutionState>();

    public void register(SimpleExecutionState state) {
        this.executionStates.add(state);
    }

    public void reset() {
        for (SimpleExecutionState state : this.executionStates) {
            state.reset();
        }
    }

    public List<MetricsApi.MonitoringInfo> getExecutionTimeMonitoringInfos() {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        for (SimpleExecutionState state : this.executionStates) {
            SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder();
            builder.setUrn(state.getUrn());
            for (Map.Entry<String, String> entry : state.getLabels().entrySet()) {
                builder.setLabel(entry.getKey(), entry.getValue());
            }
            builder.setInt64Value(state.getTotalMillis());
            monitoringInfos.add(builder.build());
        }
        return monitoringInfos;
    }
}

