/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.model.jobmanagement.v1.ArtifactRetrievalServiceGrpc;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hasher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactRetrievalService
extends ArtifactRetrievalServiceGrpc.ArtifactRetrievalServiceImplBase
implements ArtifactRetrievalService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractArtifactRetrievalService.class);
    private static final int ARTIFACT_CHUNK_SIZE_BYTES = 0x200000;
    private final Cache<String, ArtifactApi.ProxyManifest> manifestCache;

    public AbstractArtifactRetrievalService() {
        this((Cache<String, ArtifactApi.ProxyManifest>)CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(100L).build());
    }

    public AbstractArtifactRetrievalService(Cache<String, ArtifactApi.ProxyManifest> manifestCache) {
        this.manifestCache = manifestCache;
    }

    public abstract InputStream openManifest(String var1) throws IOException;

    public abstract InputStream openUri(String var1, String var2) throws IOException;

    public ArtifactApi.ProxyManifest getManifestProxy(String retrievalToken) throws IOException, ExecutionException {
        return (ArtifactApi.ProxyManifest)this.manifestCache.get((Object)retrievalToken, () -> {
            InputStream stream = this.openManifest(retrievalToken);
            Throwable throwable = null;
            try {
                ArtifactApi.ProxyManifest proxyManifest = AbstractArtifactRetrievalService.loadManifest(stream, retrievalToken);
                return proxyManifest;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    AbstractArtifactRetrievalService.$closeResource(throwable, stream);
                }
            }
        });
    }

    public void getManifest(ArtifactApi.GetManifestRequest request, StreamObserver<ArtifactApi.GetManifestResponse> responseObserver) {
        String token = request.getRetrievalToken();
        if (Strings.isNullOrEmpty((String)token)) {
            throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription("Empty artifact token"));
        }
        LOG.info("GetManifest for {}", (Object)token);
        try {
            ArtifactApi.Manifest manifest;
            if ("__no_artifacts_staged__".equals(token)) {
                manifest = ArtifactApi.Manifest.newBuilder().build();
            } else {
                ArtifactApi.ProxyManifest proxyManifest = this.getManifestProxy(token);
                LOG.info("GetManifest for {} -> {} artifacts", (Object)token, (Object)proxyManifest.getManifest().getArtifactCount());
                manifest = proxyManifest.getManifest();
            }
            ArtifactApi.GetManifestResponse response = ArtifactApi.GetManifestResponse.newBuilder().setManifest(manifest).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.warn("GetManifest for {} failed.", (Object)token, (Object)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public void getArtifact(ArtifactApi.GetArtifactRequest request, StreamObserver<ArtifactApi.ArtifactChunk> responseObserver) {
        LOG.debug("GetArtifact {}", (Object)request);
        String name = request.getName();
        try {
            ArtifactApi.ProxyManifest proxyManifest = this.getManifestProxy(request.getRetrievalToken());
            ArtifactApi.ProxyManifest.Location location = proxyManifest.getLocationList().stream().filter(loc -> loc.getName().equals(name)).findFirst().orElseThrow(() -> new StatusRuntimeException(Status.NOT_FOUND.withDescription(String.format("Artifact location not found in manifest: %s", name))));
            List existingArtifacts = proxyManifest.getManifest().getArtifactList();
            ArtifactApi.ArtifactMetadata metadata = existingArtifacts.stream().filter(meta -> meta.getName().equals(name)).findFirst().orElseThrow(() -> new StatusRuntimeException(Status.NOT_FOUND.withDescription(String.format("Artifact metadata not found in manifest: %s", name))));
            Hasher hasher = Hashing.sha256().newHasher();
            byte[] data = new byte[0x200000];
            try (InputStream stream = this.openUri(request.getRetrievalToken(), location.getUri());){
                int len;
                while ((len = stream.read(data)) != -1) {
                    hasher.putBytes(data, 0, len);
                    responseObserver.onNext((Object)ArtifactApi.ArtifactChunk.newBuilder().setData(ByteString.copyFrom((byte[])data, (int)0, (int)len)).build());
                }
            }
            if (metadata.getSha256() != null && !metadata.getSha256().isEmpty()) {
                String expected = metadata.getSha256();
                String actual = hasher.hash().toString();
                if (!actual.equals(expected)) {
                    throw new StatusRuntimeException(Status.DATA_LOSS.withDescription(String.format("Artifact %s is corrupt: expected sha256 %s, actual %s", name, expected, actual)));
                }
            }
            responseObserver.onCompleted();
        }
        catch (IOException | ExecutionException e) {
            LOG.info("GetArtifact {} failed", (Object)request, (Object)e);
            responseObserver.onError((Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    static ArtifactApi.ProxyManifest loadManifest(InputStream stream, String manifestName) throws IOException {
        ArtifactApi.ProxyManifest.Builder manifestBuilder = ArtifactApi.ProxyManifest.newBuilder();
        String contents = new String(ByteStreams.toByteArray((InputStream)stream), StandardCharsets.UTF_8);
        JsonFormat.parser().merge(contents, (Message.Builder)manifestBuilder);
        ArtifactApi.ProxyManifest proxyManifest = manifestBuilder.build();
        Preconditions.checkArgument((boolean)proxyManifest.hasManifest(), (Object)String.format("Invalid ProxyManifest at %s: doesn't have a Manifest", manifestName));
        Preconditions.checkArgument((proxyManifest.getLocationCount() == proxyManifest.getManifest().getArtifactCount() ? 1 : 0) != 0, (Object)String.format("Invalid ProxyManifestat %s: %d locations but %d artifacts", manifestName, proxyManifest.getLocationCount(), proxyManifest.getManifest().getArtifactCount()));
        LOG.info("Manifest at {} has {} artifact locations", (Object)manifestName, (Object)proxyManifest.getManifest().getArtifactCount());
        return proxyManifest;
    }
}

