/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.environment;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.environment.ProcessManager;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.environment.RemoteEnvironment;

public class ProcessEnvironment
implements RemoteEnvironment {
    private final ProcessManager processManager;
    private final RunnerApi.Environment environment;
    private final String workerId;
    private final InstructionRequestHandler instructionHandler;
    private final Object lock = new Object();
    private boolean isClosed;

    public static RemoteEnvironment create(ProcessManager processManager, RunnerApi.Environment environment, String workerId, InstructionRequestHandler instructionHandler) {
        return new ProcessEnvironment(processManager, environment, workerId, instructionHandler);
    }

    private ProcessEnvironment(ProcessManager processManager, RunnerApi.Environment environment, String workerId, InstructionRequestHandler instructionHandler) {
        this.processManager = processManager;
        this.environment = environment;
        this.workerId = workerId;
        this.instructionHandler = instructionHandler;
    }

    @Override
    public RunnerApi.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public InstructionRequestHandler getInstructionRequestHandler() {
        return this.instructionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.instructionHandler.close();
                this.processManager.stopProcess(this.workerId);
                this.isClosed = true;
            }
        }
    }
}

