/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.repackaged.direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.PCollectionViewWindow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

class SideInputContainer {
    private final Collection<PCollectionView<?>> containedViews;
    private final LoadingCache<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> viewByWindows;

    public static SideInputContainer create(EvaluationContext context, Collection<PCollectionView<?>> containedViews) {
        for (PCollectionView<?> pCollectionView : containedViews) {
            Preconditions.checkArgument((boolean)"beam:side_input:multimap:v1".equals(pCollectionView.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", (Object)"beam:side_input:multimap:v1", (Object)pCollectionView.getViewFn().getMaterialization().getUrn(), (Object)pCollectionView.getTagInternal().getId());
        }
        LoadingCache viewByWindows = CacheBuilder.newBuilder().build((CacheLoader)new CallbackSchedulingLoader(context));
        return new SideInputContainer(containedViews, viewByWindows);
    }

    private SideInputContainer(Collection<PCollectionView<?>> containedViews, LoadingCache<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> viewByWindows) {
        this.containedViews = ImmutableSet.copyOf(containedViews);
        this.viewByWindows = viewByWindows;
    }

    public ReadyCheckingSideInputReader createReaderForViews(Collection<PCollectionView<?>> newContainedViews) {
        if (!this.containedViews.containsAll(newContainedViews)) {
            ImmutableSet currentlyContained = ImmutableSet.copyOf(this.containedViews);
            ImmutableSet newRequested = ImmutableSet.copyOf(newContainedViews);
            throw new IllegalArgumentException("Can't create a SideInputReader with unknown views " + Sets.difference((Set)newRequested, (Set)currentlyContained));
        }
        return new SideInputContainerSideInputReader(newContainedViews);
    }

    public void write(PCollectionView<?> view, Iterable<? extends WindowedValue<?>> values) {
        Map<BoundedWindow, Collection<WindowedValue<?>>> valuesPerWindow = this.indexValuesByWindow(values);
        for (Map.Entry<BoundedWindow, Collection<WindowedValue<?>>> windowValues : valuesPerWindow.entrySet()) {
            this.updatePCollectionViewWindowValues(view, windowValues.getKey(), windowValues.getValue());
        }
    }

    private Map<BoundedWindow, Collection<WindowedValue<?>>> indexValuesByWindow(Iterable<? extends WindowedValue<?>> values) {
        HashMap valuesPerWindow = new HashMap();
        for (WindowedValue<?> value : values) {
            for (BoundedWindow window : value.getWindows()) {
                Collection windowValues = valuesPerWindow.computeIfAbsent(window, k -> new ArrayList());
                windowValues.add(value);
            }
        }
        return valuesPerWindow;
    }

    private void updatePCollectionViewWindowValues(PCollectionView<?> view, BoundedWindow window, Collection<WindowedValue<?>> windowValues) {
        Iterable existingValues;
        long existingPane;
        PCollectionViewWindow<?> windowedView = PCollectionViewWindow.of(view, window);
        AtomicReference contents = (AtomicReference)this.viewByWindows.getUnchecked(windowedView);
        if (contents.compareAndSet(null, windowValues)) {
            return;
        }
        PaneInfo newPane = windowValues.iterator().next().getPane();
        do {
            long l = existingPane = Iterables.isEmpty((Iterable)(existingValues = (Iterable)contents.get())) ? -1L : ((WindowedValue)existingValues.iterator().next()).getPane().getIndex();
        } while (newPane.getIndex() > existingPane && !contents.compareAndSet(existingValues, windowValues));
    }

    private class CurrentViewContentsLoader
    extends CacheLoader<PCollectionViewWindow<?>, Optional<? extends Iterable<? extends WindowedValue<?>>>> {
        private CurrentViewContentsLoader() {
        }

        public Optional<? extends Iterable<? extends WindowedValue<?>>> load(PCollectionViewWindow<?> key) {
            return Optional.ofNullable((Iterable)((AtomicReference)SideInputContainer.this.viewByWindows.getUnchecked(key)).get());
        }
    }

    private final class SideInputContainerSideInputReader
    implements ReadyCheckingSideInputReader {
        private final Collection<PCollectionView<?>> readerViews;
        private final LoadingCache<PCollectionViewWindow<?>, Optional<? extends Iterable<? extends WindowedValue<?>>>> viewContents;

        private SideInputContainerSideInputReader(Collection<PCollectionView<?>> readerViews) {
            this.readerViews = ImmutableSet.copyOf(readerViews);
            this.viewContents = CacheBuilder.newBuilder().build((CacheLoader)new CurrentViewContentsLoader());
        }

        @Override
        public boolean isReady(PCollectionView<?> view, BoundedWindow window) {
            Preconditions.checkArgument((boolean)this.readerViews.contains(view), (String)"Tried to check if view %s was ready in a SideInputReader that does not contain it. Contained views; %s", view, this.readerViews);
            return ((Optional)this.viewContents.getUnchecked(PCollectionViewWindow.of(view, window))).isPresent();
        }

        @Override
        @Nullable
        public <T> T get(PCollectionView<T> view, BoundedWindow window) {
            Preconditions.checkArgument((boolean)this.readerViews.contains(view), (String)"call to get(PCollectionView) with unknown view: %s", view);
            Preconditions.checkArgument((boolean)this.isReady(view, window), (String)"calling get() on PCollectionView %s that is not ready in window %s", view, (Object)window);
            Iterable elements = Iterables.transform((Iterable)((Iterable)((Optional)this.viewContents.getUnchecked(PCollectionViewWindow.of(view, window))).get()), WindowedValue::getValue);
            ViewFn viewFn = view.getViewFn();
            Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
            return (T)viewFn.apply(InMemoryMultimapSideInputView.fromIterable(keyCoder, elements));
        }

        @Override
        public <T> boolean contains(PCollectionView<T> view) {
            return this.readerViews.contains(view);
        }

        @Override
        public boolean isEmpty() {
            return this.readerViews.isEmpty();
        }
    }

    private static class WriteEmptyViewContents
    implements Runnable {
        private final PCollectionView<?> view;
        private final BoundedWindow window;
        private final AtomicReference<Iterable<? extends WindowedValue<?>>> contents;

        private WriteEmptyViewContents(PCollectionView<?> view, BoundedWindow window, AtomicReference<Iterable<? extends WindowedValue<?>>> contents) {
            this.contents = contents;
            this.view = view;
            this.window = window;
        }

        @Override
        public void run() {
            this.contents.compareAndSet(null, Collections.emptyList());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("view", this.view).add("window", (Object)this.window).toString();
        }
    }

    private static class CallbackSchedulingLoader
    extends CacheLoader<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> {
        private final EvaluationContext context;

        public CallbackSchedulingLoader(EvaluationContext context) {
            this.context = context;
        }

        public AtomicReference<Iterable<? extends WindowedValue<?>>> load(PCollectionViewWindow<?> view) {
            AtomicReference contents = new AtomicReference();
            WindowingStrategy windowingStrategy = view.getView().getWindowingStrategyInternal();
            this.context.scheduleAfterOutputWouldBeProduced(view.getView(), view.getWindow(), windowingStrategy, (Runnable)new WriteEmptyViewContents(view.getView(), view.getWindow(), contents));
            return contents;
        }
    }
}

