/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ParDoTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SplittableParDo;
import org.apache.beam.repackaged.direct_java.runners.core.construction.WriteFilesTranslation;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

@Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
public class PTransformMatchers {
    private PTransformMatchers() {
    }

    public static PTransformMatcher urnEqualTo(String urn) {
        return new EqualUrnPTransformMatcher(urn);
    }

    public static PTransformMatcher classEqualTo(Class<? extends PTransform> clazz) {
        return new EqualClassPTransformMatcher(clazz);
    }

    public static PTransformMatcher requiresStableInputParDoSingle() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof ParDo.SingleOutput) {
                    DoFn fn = ((ParDo.SingleOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)fn);
                    return signature.processElement().requiresStableInput();
                }
                return false;
            }

            public boolean matchesDuringValidation(AppliedPTransform<?, ?, ?> application) {
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"RequiresStableInputParDoSingleMatcher").toString();
            }
        };
    }

    public static PTransformMatcher requiresStableInputParDoMulti() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof ParDo.MultiOutput) {
                    DoFn fn = ((ParDo.MultiOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)fn);
                    return signature.processElement().requiresStableInput();
                }
                return false;
            }

            public boolean matchesDuringValidation(AppliedPTransform<?, ?, ?> application) {
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"RequiresStableInputParDoMultiMatcher").toString();
            }
        };
    }

    public static PTransformMatcher splittableParDoSingle() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof ParDo.SingleOutput) {
                    DoFn fn = ((ParDo.SingleOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)fn);
                    return signature.processElement().isSplittable();
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"SplittableParDoSingleMatcher").toString();
            }
        };
    }

    public static PTransformMatcher stateOrTimerParDoSingle() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof ParDo.SingleOutput) {
                    DoFn fn = ((ParDo.SingleOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)fn);
                    return signature.usesState() || signature.usesTimers();
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"StateOrTimerParDoSingleMatcher").toString();
            }
        };
    }

    public static PTransformMatcher splittableParDoMulti() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof ParDo.MultiOutput) {
                    DoFn fn = ((ParDo.MultiOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)fn);
                    return signature.processElement().isSplittable();
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"SplittableParDoMultiMatcher").toString();
            }
        };
    }

    public static PTransformMatcher splittableParDo() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                if ("beam:transform:pardo:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                    try {
                        return ParDoTranslation.isSplittable(application);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Transform with URN %s could not be translated", "beam:transform:pardo:v1"), e);
                    }
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"SplittableParDoMultiMatcher").toString();
            }
        };
    }

    public static PTransformMatcher splittableProcessKeyedBounded() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof SplittableParDo.ProcessKeyedElements) {
                    DoFn fn = ((SplittableParDo.ProcessKeyedElements)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().isSplittable() && signature.isBoundedPerElement() == PCollection.IsBounded.BOUNDED;
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"SplittableProcessKeyedBoundedMatcher").toString();
            }
        };
    }

    public static PTransformMatcher splittableProcessKeyedUnbounded() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof SplittableParDo.ProcessKeyedElements) {
                    DoFn fn = ((SplittableParDo.ProcessKeyedElements)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().isSplittable() && signature.isBoundedPerElement() == PCollection.IsBounded.UNBOUNDED;
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"SplittableProcessKeyedUnboundedMatcher").toString();
            }
        };
    }

    public static PTransformMatcher stateOrTimerParDo() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                if ("beam:transform:pardo:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                    try {
                        return ParDoTranslation.usesStateOrTimers(application);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Transform with URN %s could not be translated", "beam:transform:pardo:v1"), e);
                    }
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"StateOrTimerParDoMatcher").toString();
            }
        };
    }

    public static PTransformMatcher stateOrTimerParDoMulti() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                PTransform transform = application.getTransform();
                if (transform instanceof ParDo.MultiOutput) {
                    DoFn fn = ((ParDo.MultiOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)fn);
                    return signature.usesState() || signature.usesTimers();
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"StateOrTimerParDoMultiMatcher").toString();
            }
        };
    }

    public static PTransformMatcher parDoWithFnType(final Class<? extends DoFn> fnType) {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                DoFn fn;
                if (application.getTransform() instanceof ParDo.SingleOutput) {
                    fn = ((ParDo.SingleOutput)application.getTransform()).getFn();
                } else if (application.getTransform() instanceof ParDo.MultiOutput) {
                    fn = ((ParDo.MultiOutput)application.getTransform()).getFn();
                } else {
                    return false;
                }
                return fnType.equals(fn.getClass());
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ParDoWithFnTypeMatcher").add("fnType", (Object)fnType).toString();
            }
        };
    }

    public static PTransformMatcher createViewWithViewFn(Class<? extends ViewFn> viewFnType) {
        return application -> {
            if (!(application.getTransform() instanceof View.CreatePCollectionView)) {
                return false;
            }
            View.CreatePCollectionView createView = (View.CreatePCollectionView)application.getTransform();
            ViewFn viewFn = createView.getView().getViewFn();
            return viewFn.getClass().equals(viewFnType);
        };
    }

    public static PTransformMatcher emptyFlatten() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                return application.getTransform() instanceof Flatten.PCollections && application.getInputs().isEmpty();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"EmptyFlattenMatcher").toString();
            }
        };
    }

    public static PTransformMatcher flattenWithDuplicateInputs() {
        return new PTransformMatcher(){

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                if (application.getTransform() instanceof Flatten.PCollections) {
                    HashSet<PValue> observed = new HashSet<PValue>();
                    for (PValue pvalue : application.getInputs().values()) {
                        boolean firstInstance = observed.add(pvalue);
                        if (firstInstance) continue;
                        return true;
                    }
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"FlattenWithDuplicateInputsMatcher").toString();
            }
        };
    }

    public static PTransformMatcher writeWithRunnerDeterminedSharding() {
        return application -> {
            if ("beam:transform:write_files:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                try {
                    return WriteFilesTranslation.isRunnerDeterminedSharding(application);
                }
                catch (IOException exc) {
                    throw new RuntimeException(String.format("Transform with URN %s failed to parse: %s", "beam:transform:write_files:v1", application.getTransform()), exc);
                }
            }
            return false;
        };
    }

    private static class EqualClassPTransformMatcher
    implements PTransformMatcher {
        private final Class<? extends PTransform> clazz;

        private EqualClassPTransformMatcher(Class<? extends PTransform> clazz) {
            this.clazz = clazz;
        }

        public boolean matches(AppliedPTransform<?, ?, ?> application) {
            return application.getTransform().getClass().equals(this.clazz);
        }

        public String toString() {
            return MoreObjects.toStringHelper(EqualClassPTransformMatcher.class).add("class", this.clazz).toString();
        }
    }

    private static class EqualUrnPTransformMatcher
    implements PTransformMatcher {
        private final String urn;

        private EqualUrnPTransformMatcher(String urn) {
            this.urn = urn;
        }

        public boolean matches(AppliedPTransform<?, ?, ?> application) {
            return this.urn.equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("urn", (Object)this.urn).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualUrnPTransformMatcher that = (EqualUrnPTransformMatcher)o;
            return this.urn.equals(that.urn);
        }

        public int hashCode() {
            return Objects.hash(this.urn);
        }
    }
}

