/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import java.util.HashMap;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class PipelineValidator {
    private static final ImmutableMap<String, TransformValidator> VALIDATORS = ImmutableMap.builder().put((Object)"beam:transform:pardo:v1", PipelineValidator::validateParDo).put((Object)"beam:transform:window_into:v1", PipelineValidator::validateAssignWindows).put((Object)"beam:transform:teststream:v1", PipelineValidator::validateTestStream).put((Object)"beam:transform:combine_per_key:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_globally:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_per_key_precombine:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_per_key_merge_accumulators:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_per_key_extract_outputs:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:combine_grouped_values:v1", PipelineValidator::validateCombine).put((Object)"beam:transform:sdf_pair_with_restriction:v1", PipelineValidator::validateParDo).put((Object)"beam:transform:sdf_split_restriction:v1", PipelineValidator::validateParDo).put((Object)"beam:transform:sdf_process_keyed_elements:v1", PipelineValidator::validateParDo).put((Object)"beam:runner:executable_stage:v1", PipelineValidator::validateExecutableStage).build();

    public static void validate(RunnerApi.Pipeline p) {
        RunnerApi.Components components = p.getComponents();
        for (String transformId : p.getRootTransformIdsList()) {
            Preconditions.checkArgument((boolean)components.containsTransforms(transformId), (String)"Root transform id %s is unknown", (Object)transformId);
        }
        PipelineValidator.validateComponents("pipeline", components);
    }

    private static void validateComponents(String context, RunnerApi.Components components) {
        String previousId;
        HashMap uniqueNamesById = Maps.newHashMap();
        for (String transformId : components.getTransformsMap().keySet()) {
            RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
            previousId = uniqueNamesById.put(transform.getUniqueName(), transformId);
            Preconditions.checkArgument((previousId == null ? 1 : 0) != 0, (String)"%s: Transforms %s and %s both have unique_name \"%s\"", (Object)context, (Object)transformId, (Object)previousId, (Object)transform.getUniqueName());
            PipelineValidator.validateTransform(transformId, transform, components);
        }
        uniqueNamesById = Maps.newHashMap();
        for (String pcollectionId : components.getPcollectionsMap().keySet()) {
            RunnerApi.PCollection pc = components.getPcollectionsOrThrow(pcollectionId);
            Preconditions.checkArgument((!pc.getUniqueName().isEmpty() ? 1 : 0) != 0, (String)"%s: PCollection %s does not have a unique_name set", (Object)context, (Object)pcollectionId);
            previousId = uniqueNamesById.put(pc.getUniqueName(), pcollectionId);
            Preconditions.checkArgument((previousId == null ? 1 : 0) != 0, (String)"%s: PCollections %s and %s both have unique_name \"%s\"", (Object)context, (Object)pcollectionId, (Object)previousId, (Object)pc.getUniqueName());
            Preconditions.checkArgument((boolean)components.containsCoders(pc.getCoderId()), (String)"%s: PCollection %s uses unknown coder %s", (Object)context, (Object)pcollectionId, (Object)pc.getCoderId());
            Preconditions.checkArgument((boolean)components.containsWindowingStrategies(pc.getWindowingStrategyId()), (String)"%s: PCollection %s uses unknown windowing strategy %s", (Object)context, (Object)pcollectionId, (Object)pc.getWindowingStrategyId());
        }
        for (String strategyId : components.getWindowingStrategiesMap().keySet()) {
            RunnerApi.WindowingStrategy strategy = components.getWindowingStrategiesOrThrow(strategyId);
            Preconditions.checkArgument((boolean)components.containsCoders(strategy.getWindowCoderId()), (String)"%s: WindowingStrategy %s uses unknown coder %s", (Object)context, (Object)strategyId, (Object)strategy.getWindowCoderId());
        }
        for (String coderId : components.getCodersMap().keySet()) {
            for (String componentCoderId : components.getCodersOrThrow(coderId).getComponentCoderIdsList()) {
                Preconditions.checkArgument((boolean)components.containsCoders(componentCoderId), (String)"%s: Coder %s uses unknown component coder %s", (Object)context, (Object)coderId, (Object)componentCoderId);
            }
        }
    }

    private static void validateTransform(String id, RunnerApi.PTransform transform, RunnerApi.Components components) {
        String pcollectionId;
        for (String subtransformId : transform.getSubtransformsList()) {
            Preconditions.checkArgument((boolean)components.containsTransforms(subtransformId), (String)"Transform %s references unknown subtransform %s", (Object)id, (Object)subtransformId);
        }
        for (String inputId : transform.getInputsMap().keySet()) {
            pcollectionId = transform.getInputsOrThrow(inputId);
            Preconditions.checkArgument((boolean)components.containsPcollections(pcollectionId), (String)"Transform %s input %s points to unknown PCollection %s", (Object)id, (Object)inputId, (Object)pcollectionId);
        }
        for (String outputId : transform.getOutputsMap().keySet()) {
            pcollectionId = transform.getOutputsOrThrow(outputId);
            Preconditions.checkArgument((boolean)components.containsPcollections(pcollectionId), (String)"Transform %s output %s points to unknown PCollection %s", (Object)id, (Object)outputId, (Object)pcollectionId);
        }
        String urn = transform.getSpec().getUrn();
        if (VALIDATORS.containsKey((Object)urn)) {
            try {
                ((TransformValidator)VALIDATORS.get((Object)urn)).validate(id, transform, components);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to validate transform %s", id), e);
            }
        }
    }

    private static void validateParDo(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)transform.getSpec().getPayload());
        for (String sideInputId : payload.getSideInputsMap().keySet()) {
            Preconditions.checkArgument((boolean)transform.containsInputs(sideInputId), (String)"Transform %s side input %s is not listed in the transform's inputs", (Object)id, (Object)sideInputId);
        }
        if (!payload.getRestrictionCoderId().isEmpty()) {
            Preconditions.checkArgument((boolean)components.containsCoders(payload.getRestrictionCoderId()));
        }
    }

    private static void validateAssignWindows(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.WindowIntoPayload.parseFrom((ByteString)transform.getSpec().getPayload());
    }

    private static void validateTestStream(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.TestStreamPayload.parseFrom((ByteString)transform.getSpec().getPayload());
    }

    private static void validateCombine(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.CombinePayload payload = RunnerApi.CombinePayload.parseFrom((ByteString)transform.getSpec().getPayload());
        Preconditions.checkArgument((boolean)components.containsCoders(payload.getAccumulatorCoderId()), (String)"Transform %s uses unknown accumulator coder id %s", (Object)payload.getAccumulatorCoderId());
    }

    private static void validateExecutableStage(String id, RunnerApi.PTransform transform, RunnerApi.Components outerComponents) throws Exception {
        RunnerApi.ExecutableStagePayload payload = RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transform.getSpec().getPayload());
        RunnerApi.Components components = payload.getComponents();
        Preconditions.checkArgument((boolean)transform.getInputsMap().values().contains(payload.getInput()), (String)"ExecutableStage %s uses unknown input %s", (Object)id, (Object)payload.getInput());
        Preconditions.checkArgument((!payload.getTransformsList().isEmpty() ? 1 : 0) != 0, (String)"ExecutableStage %s contains no transforms", (Object)id);
        for (String subtransformId : payload.getTransformsList()) {
            Preconditions.checkArgument((boolean)components.containsTransforms(subtransformId), (String)"ExecutableStage %s uses unknown transform %s", (Object)id, (Object)subtransformId);
        }
        for (String outputId : payload.getOutputsList()) {
            Preconditions.checkArgument((boolean)components.containsPcollections(outputId), (String)"ExecutableStage %s uses unknown output %s", (Object)id, (Object)outputId);
        }
        PipelineValidator.validateComponents("ExecutableStage " + id, components);
    }

    @FunctionalInterface
    private static interface TransformValidator {
        public void validate(String var1, RunnerApi.PTransform var2, RunnerApi.Components var3) throws Exception;
    }
}

