/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterDelayFromFirstElementStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterProcessingTimeStateMachine
extends AfterDelayFromFirstElementStateMachine {
    @Override
    @Nullable
    public Instant getCurrentTime(TriggerStateMachine.TriggerContext context) {
        return context.currentProcessingTime();
    }

    private AfterProcessingTimeStateMachine(List<SerializableFunction<Instant, Instant>> transforms) {
        super(TimeDomain.PROCESSING_TIME, transforms);
    }

    public static AfterProcessingTimeStateMachine pastFirstElementInPane() {
        return new AfterProcessingTimeStateMachine(IDENTITY);
    }

    @Override
    protected AfterProcessingTimeStateMachine newWith(List<SerializableFunction<Instant, Instant>> transforms) {
        return new AfterProcessingTimeStateMachine(transforms);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterProcessingTime.pastFirstElementInPane()");
        for (SerializableFunction delayFn : this.timestampMappers) {
            builder.append(".plusDelayOf(").append(delayFn).append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTimeStateMachine)) {
            return false;
        }
        AfterProcessingTimeStateMachine that = (AfterProcessingTimeStateMachine)obj;
        return Objects.equals(this.timestampMappers, that.timestampMappers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.timestampMappers);
    }
}

