/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnControlGrpc;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.FnService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.HeaderAccessor;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.FnApiControlClient;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnApiControlClientPoolService
extends BeamFnControlGrpc.BeamFnControlImplBase
implements FnService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FnApiControlClientPoolService.class);
    private final Object lock = new Object();
    private final ControlClientPool.Sink clientSink;
    private final HeaderAccessor headerAccessor;
    @GuardedBy(value="lock")
    private final Collection<FnApiControlClient> vendedClients = new ArrayList<FnApiControlClient>();
    @GuardedBy(value="lock")
    private boolean closed = false;

    private FnApiControlClientPoolService(ControlClientPool.Sink clientSink, HeaderAccessor headerAccessor) {
        this.clientSink = clientSink;
        this.headerAccessor = headerAccessor;
    }

    public static FnApiControlClientPoolService offeringClientsToPool(ControlClientPool.Sink clientPool, HeaderAccessor headerAccessor) {
        return new FnApiControlClientPoolService(clientPool, headerAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamObserver<BeamFnApi.InstructionResponse> control(StreamObserver<BeamFnApi.InstructionRequest> requestObserver) {
        String workerId = this.headerAccessor.getSdkWorkerId();
        if (Strings.isNullOrEmpty((String)workerId)) {
            LOGGER.warn("No worker_id header provided in control request");
        }
        LOGGER.info("Beam Fn Control client connected with id {}", (Object)workerId);
        FnApiControlClient newClient = FnApiControlClient.forRequestObserver(workerId, requestObserver);
        try {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"%s already closed", (Object)FnApiControlClientPoolService.class.getSimpleName());
                this.vendedClients.add(newClient);
            }
            this.clientSink.put(this.headerAccessor.getSdkWorkerId(), newClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newClient.asResponseObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                for (FnApiControlClient vended : this.vendedClients) {
                    vended.close();
                }
            }
        }
    }
}

