/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.PCollectionViewWindow;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Optional;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.Sets;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;

class SideInputContainer {
    private final Collection<PCollectionView<?>> containedViews;
    private final LoadingCache<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> viewByWindows;

    public static SideInputContainer create(EvaluationContext context, Collection<PCollectionView<?>> containedViews) {
        LoadingCache<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> viewByWindows = CacheBuilder.newBuilder().build(new CallbackSchedulingLoader(context));
        return new SideInputContainer(containedViews, viewByWindows);
    }

    private SideInputContainer(Collection<PCollectionView<?>> containedViews, LoadingCache<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> viewByWindows) {
        this.containedViews = ImmutableSet.copyOf(containedViews);
        this.viewByWindows = viewByWindows;
    }

    public ReadyCheckingSideInputReader createReaderForViews(Collection<PCollectionView<?>> newContainedViews) {
        if (!this.containedViews.containsAll(newContainedViews)) {
            ImmutableSet<PCollectionView<?>> currentlyContained = ImmutableSet.copyOf(this.containedViews);
            ImmutableSet<PCollectionView<?>> newRequested = ImmutableSet.copyOf(newContainedViews);
            throw new IllegalArgumentException("Can't create a SideInputReader with unknown views " + Sets.difference(newRequested, currentlyContained));
        }
        return new SideInputContainerSideInputReader(newContainedViews);
    }

    public void write(PCollectionView<?> view, Iterable<? extends WindowedValue<?>> values) {
        Map<BoundedWindow, Collection<WindowedValue<?>>> valuesPerWindow = this.indexValuesByWindow(values);
        for (Map.Entry<BoundedWindow, Collection<WindowedValue<?>>> windowValues : valuesPerWindow.entrySet()) {
            this.updatePCollectionViewWindowValues(view, windowValues.getKey(), windowValues.getValue());
        }
    }

    private Map<BoundedWindow, Collection<WindowedValue<?>>> indexValuesByWindow(Iterable<? extends WindowedValue<?>> values) {
        HashMap valuesPerWindow = new HashMap();
        for (WindowedValue<?> value : values) {
            for (BoundedWindow window : value.getWindows()) {
                ArrayList windowValues = (ArrayList)valuesPerWindow.get(window);
                if (windowValues == null) {
                    windowValues = new ArrayList();
                    valuesPerWindow.put(window, windowValues);
                }
                windowValues.add(value);
            }
        }
        return valuesPerWindow;
    }

    private void updatePCollectionViewWindowValues(PCollectionView<?> view, BoundedWindow window, Collection<WindowedValue<?>> windowValues) {
        Iterable<WindowedValue<?>> existingValues;
        long existingPane;
        PCollectionViewWindow<?> windowedView = PCollectionViewWindow.of(view, window);
        AtomicReference<Iterable<WindowedValue<?>>> contents = this.viewByWindows.getUnchecked(windowedView);
        if (contents.compareAndSet(null, windowValues)) {
            return;
        }
        PaneInfo newPane = windowValues.iterator().next().getPane();
        do {
            long l = existingPane = Iterables.isEmpty(existingValues = contents.get()) ? -1L : existingValues.iterator().next().getPane().getIndex();
        } while (newPane.getIndex() > existingPane && !contents.compareAndSet(existingValues, windowValues));
    }

    private class CurrentViewContentsLoader
    extends CacheLoader<PCollectionViewWindow<?>, Optional<? extends Iterable<? extends WindowedValue<?>>>> {
        private CurrentViewContentsLoader() {
        }

        @Override
        public Optional<? extends Iterable<? extends WindowedValue<?>>> load(PCollectionViewWindow<?> key) {
            return Optional.fromNullable(((AtomicReference)SideInputContainer.this.viewByWindows.getUnchecked(key)).get());
        }
    }

    private final class SideInputContainerSideInputReader
    implements ReadyCheckingSideInputReader {
        private final Collection<PCollectionView<?>> readerViews;
        private final LoadingCache<PCollectionViewWindow<?>, Optional<? extends Iterable<? extends WindowedValue<?>>>> viewContents;

        private SideInputContainerSideInputReader(Collection<PCollectionView<?>> readerViews) {
            this.readerViews = ImmutableSet.copyOf(readerViews);
            this.viewContents = CacheBuilder.newBuilder().build(new CurrentViewContentsLoader());
        }

        @Override
        public boolean isReady(PCollectionView<?> view, BoundedWindow window) {
            Preconditions.checkArgument(this.readerViews.contains(view), "Tried to check if view %s was ready in a SideInputReader that does not contain it. Contained views; %s", view, this.readerViews);
            return this.viewContents.getUnchecked(PCollectionViewWindow.of(view, window)).isPresent();
        }

        @Override
        @Nullable
        public <T> T get(PCollectionView<T> view, BoundedWindow window) {
            Preconditions.checkArgument(this.readerViews.contains(view), "call to get(PCollectionView) with unknown view: %s", view);
            Preconditions.checkArgument(this.isReady(view, window), "calling get() on PCollectionView %s that is not ready in window %s", view, (Object)window);
            Iterable<? extends WindowedValue<?>> values = this.viewContents.getUnchecked(PCollectionViewWindow.of(view, window)).get();
            return (T)view.getViewFn().apply(values);
        }

        @Override
        public <T> boolean contains(PCollectionView<T> view) {
            return this.readerViews.contains(view);
        }

        @Override
        public boolean isEmpty() {
            return this.readerViews.isEmpty();
        }
    }

    private static class WriteEmptyViewContents
    implements Runnable {
        private final PCollectionView<?> view;
        private final BoundedWindow window;
        private final AtomicReference<Iterable<? extends WindowedValue<?>>> contents;

        private WriteEmptyViewContents(PCollectionView<?> view, BoundedWindow window, AtomicReference<Iterable<? extends WindowedValue<?>>> contents) {
            this.contents = contents;
            this.view = view;
            this.window = window;
        }

        @Override
        public void run() {
            this.contents.compareAndSet(null, Collections.emptyList());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("view", this.view).add("window", this.window).toString();
        }
    }

    private static class CallbackSchedulingLoader
    extends CacheLoader<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> {
        private final EvaluationContext context;

        public CallbackSchedulingLoader(EvaluationContext context) {
            this.context = context;
        }

        @Override
        public AtomicReference<Iterable<? extends WindowedValue<?>>> load(PCollectionViewWindow<?> view) {
            AtomicReference contents = new AtomicReference();
            WindowingStrategy windowingStrategy = view.getView().getWindowingStrategyInternal();
            this.context.scheduleAfterOutputWouldBeProduced(view.getView(), view.getWindow(), windowingStrategy, (Runnable)new WriteEmptyViewContents(view.getView(), view.getWindow(), contents));
            return contents;
        }
    }
}

