/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.DoFnLifecycleManagerRemovingTransformEvaluator;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.ParDoEvaluatorFactory;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.runners.direct.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.beam.runners.direct.repackaged.runners.core.DoFnRunners;
import org.apache.beam.runners.direct.repackaged.runners.core.KeyedWorkItem;
import org.apache.beam.runners.direct.repackaged.runners.core.OutputAndTimeBoundedSplittableProcessElementInvoker;
import org.apache.beam.runners.direct.repackaged.runners.core.OutputWindowedValue;
import org.apache.beam.runners.direct.repackaged.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.direct.repackaged.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternalsFactory;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternalsFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;
import org.joda.time.Instant;

class SplittableProcessElementsEvaluatorFactory<InputT, OutputT, RestrictionT, TrackerT extends RestrictionTracker<RestrictionT>>
implements TransformEvaluatorFactory {
    private final ParDoEvaluatorFactory<KeyedWorkItem<String, KV<InputT, RestrictionT>>, OutputT> delegateFactory;
    private final EvaluationContext evaluationContext;

    SplittableProcessElementsEvaluatorFactory(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
        this.delegateFactory = new ParDoEvaluatorFactory<KeyedWorkItem<String, KV<KeyedWorkItem<String, KV<InputT, RestrictionT>>, RestrictionT>>, OutputT>(evaluationContext, SplittableProcessElementsEvaluatorFactory.processFnRunnerFactory(), ParDoEvaluatorFactory.basicDoFnCacheLoader());
    }

    public <T> TransformEvaluator<T> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws Exception {
        TransformEvaluator<KeyedWorkItem<String, KV<?, RestrictionT>>> evaluator = this.createEvaluator(application, inputBundle);
        return evaluator;
    }

    @Override
    public void cleanup() throws Exception {
        this.delegateFactory.cleanup();
    }

    private TransformEvaluator<KeyedWorkItem<String, KV<InputT, RestrictionT>>> createEvaluator(AppliedPTransform<PCollection<KeyedWorkItem<String, KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDoViaKeyedWorkItems.ProcessElements<InputT, OutputT, RestrictionT, TrackerT>> application, CommittedBundle<InputT> inputBundle) throws Exception {
        final SplittableParDoViaKeyedWorkItems.ProcessElements transform = (SplittableParDoViaKeyedWorkItems.ProcessElements)application.getTransform();
        SplittableParDoViaKeyedWorkItems.ProcessFn processFn = transform.newProcessFn(transform.getFn());
        DoFnLifecycleManager fnManager = DoFnLifecycleManager.of(processFn);
        processFn = (SplittableParDoViaKeyedWorkItems.ProcessFn)fnManager.get();
        String stepName = this.evaluationContext.getStepName(application);
        final DirectExecutionContext.DirectStepContext stepContext = this.evaluationContext.getExecutionContext(application, inputBundle.getKey()).getStepContext(stepName);
        final ParDoEvaluator<KeyedWorkItem<String, KV<InputT, RestrictionT>>> parDoEvaluator = this.delegateFactory.createParDoEvaluator(application, inputBundle.getKey(), inputBundle.getPCollection(), transform.getSideInputs(), transform.getMainOutputTag(), transform.getAdditionalOutputTags().getAll(), stepContext, processFn, fnManager);
        processFn.setStateInternalsFactory(new StateInternalsFactory<String>(){

            @Override
            public StateInternals stateInternalsForKey(String key) {
                return stepContext.stateInternals();
            }
        });
        processFn.setTimerInternalsFactory(new TimerInternalsFactory<String>(){

            @Override
            public TimerInternals timerInternalsForKey(String key) {
                return stepContext.timerInternals();
            }
        });
        OutputWindowedValue outputWindowedValue = new OutputWindowedValue<OutputT>(){
            private final DoFnRunners.OutputManager outputManager;
            {
                this.outputManager = parDoEvaluator.getOutputManager();
            }

            @Override
            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                this.outputManager.output(transform.getMainOutputTag(), WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }

            @Override
            public <AdditionalOutputT> void outputWindowedValue(TupleTag<AdditionalOutputT> tag, AdditionalOutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                this.outputManager.output(tag, WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }
        };
        processFn.setProcessElementInvoker(new OutputAndTimeBoundedSplittableProcessElementInvoker(transform.getFn(), this.evaluationContext.getPipelineOptions(), outputWindowedValue, this.evaluationContext.createSideInputReader(transform.getSideInputs()), Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setThreadFactory(MoreExecutors.platformThreadFactory()).setDaemon(true).setNameFormat("direct-splittable-process-element-checkpoint-executor").build()), 100, Duration.standardSeconds((long)1L)));
        return DoFnLifecycleManagerRemovingTransformEvaluator.wrapping(parDoEvaluator, fnManager);
    }

    private static <InputT, OutputT, RestrictionT> ParDoEvaluator.DoFnRunnerFactory<KeyedWorkItem<String, KV<InputT, RestrictionT>>, OutputT> processFnRunnerFactory() {
        return new ParDoEvaluator.DoFnRunnerFactory<KeyedWorkItem<String, KV<InputT, RestrictionT>>, OutputT>(){

            @Override
            public PushbackSideInputDoFnRunner<KeyedWorkItem<String, KV<InputT, RestrictionT>>, OutputT> createRunner(PipelineOptions options, DoFn<KeyedWorkItem<String, KV<InputT, RestrictionT>>, OutputT> fn, List<PCollectionView<?>> sideInputs, ReadyCheckingSideInputReader sideInputReader, DoFnRunners.OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, DirectExecutionContext.DirectStepContext stepContext, WindowingStrategy<?, ? extends BoundedWindow> windowingStrategy) {
                SplittableParDoViaKeyedWorkItems.ProcessFn processFn = (SplittableParDoViaKeyedWorkItems.ProcessFn)fn;
                return DoFnRunners.newProcessFnRunner(processFn, options, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, windowingStrategy);
            }
        };
    }
}

