/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.ByteString;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.CoderTranslator;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.CoderTranslators;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.BiMap;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValue;

public class CoderTranslation {
    public static final String JAVA_SERIALIZED_CODER_URN = "urn:beam:coders:javasdk:0.1";
    @VisibleForTesting
    static final BiMap<Class<? extends StructuredCoder>, String> KNOWN_CODER_URNS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(ByteArrayCoder.class, "urn:beam:coders:bytes:0.1")).put(KvCoder.class, "urn:beam:coders:kv:0.1")).put(VarLongCoder.class, "urn:beam:coders:varint:0.1")).put(IntervalWindow.IntervalWindowCoder.class, "urn:beam:coders:interval_window:0.1")).put(IterableCoder.class, "urn:beam:coders:stream:0.1")).put(LengthPrefixCoder.class, "urn:beam:coders:length_prefix:0.1")).put(GlobalWindow.Coder.class, "urn:beam:coders:global_window:0.1")).put(WindowedValue.FullWindowedValueCoder.class, "urn:beam:coders:windowed_value:0.1")).build();
    @VisibleForTesting
    static final Map<Class<? extends StructuredCoder>, CoderTranslator<? extends StructuredCoder>> KNOWN_TRANSLATORS = ImmutableMap.builder().put(ByteArrayCoder.class, CoderTranslators.atomic(ByteArrayCoder.class)).put(VarLongCoder.class, CoderTranslators.atomic(VarLongCoder.class)).put(IntervalWindow.IntervalWindowCoder.class, CoderTranslators.atomic(IntervalWindow.IntervalWindowCoder.class)).put(GlobalWindow.Coder.class, CoderTranslators.atomic(GlobalWindow.Coder.class)).put(KvCoder.class, CoderTranslators.kv()).put(IterableCoder.class, CoderTranslators.iterable()).put(LengthPrefixCoder.class, CoderTranslators.lengthPrefix()).put(WindowedValue.FullWindowedValueCoder.class, CoderTranslators.fullWindowedValue()).build();

    public static RunnerApi.MessageWithComponents toProto(Coder<?> coder) throws IOException {
        SdkComponents components = SdkComponents.create();
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, components);
        return RunnerApi.MessageWithComponents.newBuilder().setCoder(coderProto).setComponents(components.toComponents()).build();
    }

    public static RunnerApi.Coder toProto(Coder<?> coder, SdkComponents components) throws IOException {
        if (KNOWN_CODER_URNS.containsKey(coder.getClass())) {
            return CoderTranslation.toKnownCoder(coder, components);
        }
        return CoderTranslation.toCustomCoder(coder);
    }

    private static RunnerApi.Coder toKnownCoder(Coder<?> coder, SdkComponents components) throws IOException {
        Preconditions.checkArgument(coder instanceof StructuredCoder, "A Known %s must implement %s, but %s of class %s does not", (Object)Coder.class.getSimpleName(), (Object)StructuredCoder.class.getSimpleName(), coder, (Object)coder.getClass().getName());
        StructuredCoder stdCoder = (StructuredCoder)coder;
        CoderTranslator<? extends StructuredCoder> translator = KNOWN_TRANSLATORS.get(stdCoder.getClass());
        List<String> componentIds = CoderTranslation.registerComponents(coder, translator, components);
        return RunnerApi.Coder.newBuilder().addAllComponentCoderIds(componentIds).setSpec(RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn((String)KNOWN_CODER_URNS.get(stdCoder.getClass())))).build();
    }

    private static <T extends Coder<?>> List<String> registerComponents(T coder, CoderTranslator<T> translator, SdkComponents components) throws IOException {
        ArrayList<String> componentIds = new ArrayList<String>();
        for (Coder<?> component : translator.getComponents(coder)) {
            componentIds.add(components.registerCoder(component));
        }
        return componentIds;
    }

    private static RunnerApi.Coder toCustomCoder(Coder<?> coder) throws IOException {
        RunnerApi.Coder.Builder coderBuilder = RunnerApi.Coder.newBuilder();
        return coderBuilder.setSpec(RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_CODER_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(coder))).build())).build();
    }

    public static Coder<?> fromProto(RunnerApi.Coder protoCoder, RehydratedComponents components) throws IOException {
        String coderSpecUrn = protoCoder.getSpec().getSpec().getUrn();
        if (coderSpecUrn.equals(JAVA_SERIALIZED_CODER_URN)) {
            return CoderTranslation.fromCustomCoder(protoCoder);
        }
        return CoderTranslation.fromKnownCoder(protoCoder, components);
    }

    private static Coder<?> fromKnownCoder(RunnerApi.Coder coder, RehydratedComponents components) throws IOException {
        String coderUrn = coder.getSpec().getSpec().getUrn();
        LinkedList coderComponents = new LinkedList();
        for (String componentId : coder.getComponentCoderIdsList()) {
            Coder<?> innerCoder = components.getCoder(componentId);
            coderComponents.add(innerCoder);
        }
        Class coderType = (Class)KNOWN_CODER_URNS.inverse().get(coderUrn);
        CoderTranslator<? extends StructuredCoder> translator = KNOWN_TRANSLATORS.get(coderType);
        Preconditions.checkArgument(translator != null, "Unknown Coder URN %s. Known URNs: %s", (Object)coderUrn, KNOWN_CODER_URNS.values());
        return translator.fromComponents(coderComponents);
    }

    private static Coder<?> fromCustomCoder(RunnerApi.Coder protoCoder) throws IOException {
        return (Coder)SerializableUtils.deserializeFromByteArray((byte[])protoCoder.getSpec().getSpec().getPayload().toByteArray(), (String)"Custom Coder Bytes");
    }
}

