/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.fn;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.fn.v1.BeamFnApi;
import org.apache.beam.runners.direct.repackaged.runners.core.fn.AutoValue_SdkHarnessClient_ActiveBundle;
import org.apache.beam.runners.direct.repackaged.runners.core.fn.FnApiControlClient;
import org.apache.beam.runners.direct.repackaged.runners.core.fn.FnDataReceiver;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Function;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.util.concurrent.Futures;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.util.concurrent.ListenableFuture;

public class SdkHarnessClient {
    private final IdGenerator idGenerator;
    private final FnApiControlClient fnApiControlClient;

    private SdkHarnessClient(FnApiControlClient fnApiControlClient, IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        this.fnApiControlClient = fnApiControlClient;
    }

    public static SdkHarnessClient usingFnApiClient(FnApiControlClient fnApiControlClient) {
        return new SdkHarnessClient(fnApiControlClient, new CountingIdGenerator());
    }

    public SdkHarnessClient withIdGenerator(IdGenerator idGenerator) {
        return new SdkHarnessClient(this.fnApiControlClient, idGenerator);
    }

    public Future<BeamFnApi.RegisterResponse> register(Iterable<BeamFnApi.ProcessBundleDescriptor> processBundleDescriptors) {
        ListenableFuture<BeamFnApi.InstructionResponse> genericResponse = this.fnApiControlClient.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(this.idGenerator.getId()).setRegister(BeamFnApi.RegisterRequest.newBuilder().addAllProcessBundleDescriptor(processBundleDescriptors).build()).build());
        return Futures.transform(genericResponse, new Function<BeamFnApi.InstructionResponse, BeamFnApi.RegisterResponse>(){

            @Override
            public BeamFnApi.RegisterResponse apply(BeamFnApi.InstructionResponse input) {
                return input.getRegister();
            }
        });
    }

    public ActiveBundle newBundle(String processBundleDescriptorId) {
        String bundleId = this.idGenerator.getId();
        FnDataReceiver dataReceiver = new FnDataReceiver(){

            public void accept(Object input) throws Exception {
                throw new UnsupportedOperationException("Placeholder FnDataReceiver cannot accept data.");
            }

            @Override
            public void close() throws IOException {
            }
        };
        ListenableFuture<BeamFnApi.InstructionResponse> genericResponse = this.fnApiControlClient.handle(BeamFnApi.InstructionRequest.newBuilder().setProcessBundle(BeamFnApi.ProcessBundleRequest.newBuilder().setProcessBundleDescriptorReference(processBundleDescriptorId)).build());
        ListenableFuture<BeamFnApi.ProcessBundleResponse> specificResponse = Futures.transform(genericResponse, new Function<BeamFnApi.InstructionResponse, BeamFnApi.ProcessBundleResponse>(){

            @Override
            public BeamFnApi.ProcessBundleResponse apply(BeamFnApi.InstructionResponse input) {
                return input.getProcessBundle();
            }
        });
        return ActiveBundle.create(bundleId, specificResponse, dataReceiver);
    }

    public static abstract class ActiveBundle<InputT> {
        public abstract String getBundleId();

        public abstract Future<BeamFnApi.ProcessBundleResponse> getBundleResponse();

        public abstract FnDataReceiver<InputT> getInputReceiver();

        public static <InputT> ActiveBundle<InputT> create(String bundleId, Future<BeamFnApi.ProcessBundleResponse> response, FnDataReceiver<InputT> dataReceiver) {
            return new AutoValue_SdkHarnessClient_ActiveBundle<InputT>(bundleId, response, dataReceiver);
        }
    }

    private static class CountingIdGenerator
    implements IdGenerator {
        private final AtomicLong nextId = new AtomicLong(0L);

        private CountingIdGenerator() {
        }

        @Override
        public String getId() {
            return String.valueOf(this.nextId.incrementAndGet());
        }
    }

    public static interface IdGenerator {
        public String getId();
    }
}

