/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;

public class Environments {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    public static final String ENVIRONMENT_DOCKER = "DOCKER";
    public static final String ENVIRONMENT_PROCESS = "PROCESS";
    public static final String ENVIRONMENT_EXTERNAL = "EXTERNAL";
    public static final String ENVIRONMENT_EMBEDDED = "EMBEDDED";
    public static final String ENVIRONMENT_LOOPBACK = "LOOPBACK";
    private static final String JAVA_SDK_HARNESS_CONTAINER_URL = ReleaseInfo.getReleaseInfo().getDefaultDockerRepoRoot() + "/" + ReleaseInfo.getReleaseInfo().getDefaultDockerRepoPrefix() + "java_sdk:" + ReleaseInfo.getReleaseInfo().getSdkVersion();
    public static final RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = Environments.createDockerEnvironment(JAVA_SDK_HARNESS_CONTAINER_URL);

    private Environments() {
    }

    public static RunnerApi.Environment createOrGetDefaultEnvironment(String type, String config) {
        if (Strings.isNullOrEmpty((String)type)) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        switch (type) {
            case "EMBEDDED": {
                return Environments.createEmbeddedEnvironment(config);
            }
            case "EXTERNAL": 
            case "LOOPBACK": {
                return Environments.createExternalEnvironment(config);
            }
            case "PROCESS": {
                return Environments.createProcessEnvironment(config);
            }
        }
        return Environments.createDockerEnvironment(config);
    }

    public static RunnerApi.Environment createDockerEnvironment(String dockerImageUrl) {
        if (Strings.isNullOrEmpty((String)dockerImageUrl)) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerImageUrl).build().toByteString()).build();
    }

    private static RunnerApi.Environment createExternalEnvironment(String config) {
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL)).setPayload(RunnerApi.ExternalPayload.newBuilder().setEndpoint(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(config).build()).build().toByteString()).build();
    }

    private static RunnerApi.Environment createProcessEnvironment(String config) {
        try {
            ProcessPayloadReferenceJSON payloadReferenceJSON = (ProcessPayloadReferenceJSON)MAPPER.readValue(config, ProcessPayloadReferenceJSON.class);
            return Environments.createProcessEnvironment(payloadReferenceJSON.getOs(), payloadReferenceJSON.getArch(), payloadReferenceJSON.getCommand(), payloadReferenceJSON.getEnv());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to parse process environment config: %s", config), e);
        }
    }

    private static RunnerApi.Environment createEmbeddedEnvironment(String config) {
        return RunnerApi.Environment.newBuilder().setUrn(ENVIRONMENT_EMBEDDED).setPayload(ByteString.copyFromUtf8((String)((String)MoreObjects.firstNonNull((Object)config, (Object)"")))).build();
    }

    public static RunnerApi.Environment createProcessEnvironment(String os, String arch, String command, Map<String, String> env) {
        RunnerApi.ProcessPayload.Builder builder = RunnerApi.ProcessPayload.newBuilder();
        if (!Strings.isNullOrEmpty((String)os)) {
            builder.setOs(os);
        }
        if (!Strings.isNullOrEmpty((String)arch)) {
            builder.setArch(arch);
        }
        if (!Strings.isNullOrEmpty((String)command)) {
            builder.setCommand(command);
        }
        if (env != null) {
            builder.putAllEnv(env);
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.PROCESS)).setPayload(builder.build().toByteString()).build();
    }

    public static Optional<RunnerApi.Environment> getEnvironment(String ptransformId, RunnerApi.Components components) {
        RunnerApi.PTransform ptransform = components.getTransformsOrThrow(ptransformId);
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironmentsOrThrow(envId));
    }

    public static Optional<RunnerApi.Environment> getEnvironment(RunnerApi.PTransform ptransform, RehydratedComponents components) {
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironment(envId));
    }

    private static class ProcessPayloadReferenceJSON {
        @Nullable
        private String os;
        @Nullable
        private String arch;
        @Nullable
        private String command;
        @Nullable
        private Map<String, String> env;

        private ProcessPayloadReferenceJSON() {
        }

        @Nullable
        public String getOs() {
            return this.os;
        }

        @Nullable
        public String getArch() {
            return this.arch;
        }

        @Nullable
        public String getCommand() {
            return this.command;
        }

        @Nullable
        public Map<String, String> getEnv() {
            return this.env;
        }
    }
}

