/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.DisplayDataTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ExternalTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ParDoTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

public class PTransformTranslation {
    public static final String PAR_DO_TRANSFORM_URN = "beam:transform:pardo:v1";
    public static final String FLATTEN_TRANSFORM_URN = "beam:transform:flatten:v1";
    public static final String GROUP_BY_KEY_TRANSFORM_URN = "beam:transform:group_by_key:v1";
    public static final String IMPULSE_TRANSFORM_URN = "beam:transform:impulse:v1";
    public static final String ASSIGN_WINDOWS_TRANSFORM_URN = "beam:transform:window_into:v1";
    public static final String TEST_STREAM_TRANSFORM_URN = "beam:transform:teststream:v1";
    public static final String MAP_WINDOWS_TRANSFORM_URN = "beam:transform:map_windows:v1";
    public static final String MERGE_WINDOWS_TRANSFORM_URN = "beam:transform:merge_windows:v1";
    @Deprecated
    public static final String READ_TRANSFORM_URN = "beam:transform:read:v1";
    @Deprecated
    public static final String CREATE_VIEW_TRANSFORM_URN = "beam:transform:create_view:v1";
    public static final String COMBINE_PER_KEY_TRANSFORM_URN = "beam:transform:combine_per_key:v1";
    public static final String COMBINE_GLOBALLY_TRANSFORM_URN = "beam:transform:combine_globally:v1";
    public static final String RESHUFFLE_URN = "beam:transform:reshuffle:v1";
    public static final String WRITE_FILES_TRANSFORM_URN = "beam:transform:write_files:v1";
    public static final String COMBINE_PER_KEY_PRECOMBINE_TRANSFORM_URN = "beam:transform:combine_per_key_precombine:v1";
    public static final String COMBINE_PER_KEY_MERGE_ACCUMULATORS_TRANSFORM_URN = "beam:transform:combine_per_key_merge_accumulators:v1";
    public static final String COMBINE_PER_KEY_EXTRACT_OUTPUTS_TRANSFORM_URN = "beam:transform:combine_per_key_extract_outputs:v1";
    public static final String COMBINE_GROUPED_VALUES_TRANSFORM_URN = "beam:transform:combine_grouped_values:v1";
    public static final String SPLITTABLE_PAIR_WITH_RESTRICTION_URN = "beam:transform:sdf_pair_with_restriction:v1";
    public static final String SPLITTABLE_SPLIT_RESTRICTION_URN = "beam:transform:sdf_split_restriction:v1";
    @Deprecated
    public static final String SPLITTABLE_PROCESS_KEYED_URN = "beam:transform:sdf_process_keyed_elements:v1";
    public static final String SPLITTABLE_PROCESS_ELEMENTS_URN = "beam:transform:sdf_process_elements:v1";
    public static final String SPLITTABLE_SPLIT_AND_SIZE_RESTRICTIONS_URN = "beam:transform:sdf_split_and_size_restrictions:v1";
    public static final String SPLITTABLE_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS_URN = "beam:transform:sdf_process_sized_element_and_restrictions:v1";
    private static final Collection<TransformTranslator<?>> KNOWN_TRANSLATORS;

    private static Collection<TransformTranslator<?>> loadKnownTranslators() {
        return ImmutableSortedSet.orderedBy((Comparator)ReflectHelpers.ObjectsClassComparator.INSTANCE).add((Object)new RawPTransformTranslator()).add(new KnownTransformPayloadTranslator()).add((Object)ParDoTranslation.ParDoTranslator.create()).add((Object)ExternalTranslation.ExternalTranslator.create()).build();
    }

    private PTransformTranslation() {
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        TransformTranslator transformTranslator = (TransformTranslator)Iterables.find(KNOWN_TRANSLATORS, translator -> translator.canTranslate(appliedPTransform.getTransform()), (Object)DefaultUnknownTransformTranslator.INSTANCE);
        return transformTranslator.translate(appliedPTransform, subtransforms, components);
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, SdkComponents components) throws IOException {
        return PTransformTranslation.toProto(appliedPTransform, Collections.emptyList(), components);
    }

    private static String toProto(TupleTag<?> tag) {
        return tag.getId();
    }

    @Nullable
    public static String urnForTransformOrNull(PTransform<?, ?> transform) {
        TransformTranslator transformTranslator = (TransformTranslator)Iterables.find(KNOWN_TRANSLATORS, translator -> translator.canTranslate(transform), (Object)DefaultUnknownTransformTranslator.INSTANCE);
        return transformTranslator.getUrn(transform);
    }

    public static String urnForTransform(PTransform<?, ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        if (urn == null) {
            throw new IllegalStateException(String.format("No translator known for %s", transform.getClass().getName()));
        }
        return urn;
    }

    @Nullable
    public static String urnForTransformOrNull(RunnerApi.PTransform transform) {
        return transform.getSpec() == null ? null : transform.getSpec().getUrn();
    }

    static RunnerApi.PTransform.Builder translateAppliedPTransform(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
        for (Map.Entry entry : appliedPTransform.getInputs().entrySet()) {
            Preconditions.checkArgument((boolean)(entry.getValue() instanceof PCollection), (String)"Unexpected input type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putInputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (Map.Entry entry : appliedPTransform.getOutputs().entrySet()) {
            if (!(entry.getValue() instanceof PCollection)) continue;
            Preconditions.checkArgument((boolean)(entry.getValue() instanceof PCollection), (String)"Unexpected output type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putOutputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (AppliedPTransform appliedPTransform2 : subtransforms) {
            transformBuilder.addSubtransforms(components.getExistingPTransformId(appliedPTransform2));
        }
        transformBuilder.setUniqueName(appliedPTransform.getFullName());
        transformBuilder.addAllDisplayData(DisplayDataTranslation.toProto(DisplayData.from((HasDisplayData)appliedPTransform.getTransform())));
        return transformBuilder;
    }

    static {
        Preconditions.checkState((boolean)PAR_DO_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.PAR_DO)));
        Preconditions.checkState((boolean)FLATTEN_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.FLATTEN)));
        Preconditions.checkState((boolean)GROUP_BY_KEY_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.GROUP_BY_KEY)));
        Preconditions.checkState((boolean)IMPULSE_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.IMPULSE)));
        Preconditions.checkState((boolean)ASSIGN_WINDOWS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.ASSIGN_WINDOWS)));
        Preconditions.checkState((boolean)TEST_STREAM_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.TEST_STREAM)));
        Preconditions.checkState((boolean)MAP_WINDOWS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.MAP_WINDOWS)));
        Preconditions.checkState((boolean)MERGE_WINDOWS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.MERGE_WINDOWS)));
        Preconditions.checkState((boolean)READ_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.DeprecatedPrimitives.READ)));
        Preconditions.checkState((boolean)CREATE_VIEW_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.DeprecatedPrimitives.CREATE_VIEW)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.COMBINE_PER_KEY)));
        Preconditions.checkState((boolean)COMBINE_GLOBALLY_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.COMBINE_GLOBALLY)));
        Preconditions.checkState((boolean)RESHUFFLE_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.RESHUFFLE)));
        Preconditions.checkState((boolean)WRITE_FILES_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.WRITE_FILES)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_PRECOMBINE_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_PRECOMBINE)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_MERGE_ACCUMULATORS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_MERGE_ACCUMULATORS)));
        Preconditions.checkState((boolean)COMBINE_PER_KEY_EXTRACT_OUTPUTS_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_EXTRACT_OUTPUTS)));
        Preconditions.checkState((boolean)COMBINE_GROUPED_VALUES_TRANSFORM_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.CombineComponents.COMBINE_GROUPED_VALUES)));
        Preconditions.checkState((boolean)SPLITTABLE_PAIR_WITH_RESTRICTION_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PAIR_WITH_RESTRICTION)));
        Preconditions.checkState((boolean)SPLITTABLE_SPLIT_RESTRICTION_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.SPLIT_RESTRICTION)));
        Preconditions.checkState((boolean)SPLITTABLE_PROCESS_KEYED_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_KEYED_ELEMENTS)));
        Preconditions.checkState((boolean)SPLITTABLE_PROCESS_ELEMENTS_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_ELEMENTS)));
        Preconditions.checkState((boolean)SPLITTABLE_SPLIT_AND_SIZE_RESTRICTIONS_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.SPLIT_AND_SIZE_RESTRICTIONS)));
        Preconditions.checkState((boolean)SPLITTABLE_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS_URN.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS)));
        KNOWN_TRANSLATORS = PTransformTranslation.loadKnownTranslators();
    }

    public static abstract class RawPTransform<InputT extends PInput, OutputT extends POutput>
    extends PTransform<InputT, OutputT> {
        @Nullable
        public String getUrn() {
            return this.getSpec() == null ? null : this.getSpec().getUrn();
        }

        @Nullable
        public abstract RunnerApi.FunctionSpec getSpec();

        public RunnerApi.FunctionSpec migrate(SdkComponents components) throws IOException {
            return this.getSpec();
        }

        public OutputT expand(InputT input) {
            throw new IllegalStateException(String.format("%s should never be asked to expand; it is the result of deserializing an already-constructed Pipeline", ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }

    public static interface TransformPayloadTranslator<T extends PTransform<?, ?>> {
        public String getUrn(T var1);

        @Nullable
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> var1, SdkComponents var2) throws IOException;

        public static abstract class NotSerializable<T extends PTransform<?, ?>>
        implements TransformPayloadTranslator<T> {
            public static NotSerializable<?> forUrn(final String urn) {
                return new NotSerializable<PTransform<?, ?>>(){

                    @Override
                    public String getUrn(PTransform<?, ?> transform) {
                        return urn;
                    }
                };
            }

            @Override
            public final RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> transform, SdkComponents components) throws IOException {
                throw new UnsupportedOperationException(String.format("%s should never be translated", transform.getTransform().getClass().getCanonicalName()));
            }
        }
    }

    private static class KnownTransformPayloadTranslator<T extends PTransform<?, ?>>
    implements TransformTranslator<T> {
        private static final Map<Class<? extends PTransform>, TransformPayloadTranslator> KNOWN_PAYLOAD_TRANSLATORS = KnownTransformPayloadTranslator.loadTransformPayloadTranslators();
        private static List<String> sdkTransformsWithEnvironment = ImmutableList.of((Object)"beam:transform:pardo:v1", (Object)"beam:transform:combine_per_key:v1", (Object)"beam:transform:window_into:v1");

        private KnownTransformPayloadTranslator() {
        }

        private static Map<Class<? extends PTransform>, TransformPayloadTranslator> loadTransformPayloadTranslators() {
            HashMap<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> translators = new HashMap<Class<? extends PTransform>, TransformPayloadTranslator>();
            for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
                Map<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> newTranslators = registrar.getTransformPayloadTranslators();
                Sets.SetView alreadyRegistered = Sets.intersection(translators.keySet(), newTranslators.keySet());
                if (!alreadyRegistered.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Classes already registered: %s", Joiner.on((String)", ").join((Iterable)alreadyRegistered)));
                }
                translators.putAll(newTranslators);
            }
            return ImmutableMap.copyOf(translators);
        }

        @Override
        public boolean canTranslate(PTransform pTransform) {
            return KNOWN_PAYLOAD_TRANSLATORS.containsKey(pTransform.getClass());
        }

        @Override
        public String getUrn(PTransform transform) {
            return KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass()).getUrn(transform);
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder transformBuilder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            RunnerApi.FunctionSpec spec = KNOWN_PAYLOAD_TRANSLATORS.get(appliedPTransform.getTransform().getClass()).translate(appliedPTransform, components);
            if (spec != null) {
                transformBuilder.setSpec(spec);
                if (sdkTransformsWithEnvironment.contains(spec.getUrn())) {
                    transformBuilder.setEnvironmentId(components.getOnlyEnvironmentId());
                } else if (spec.getUrn().equals(PTransformTranslation.READ_TRANSFORM_URN) && appliedPTransform.getTransform().getClass() == Read.Bounded.class) {
                    transformBuilder.setEnvironmentId(components.getOnlyEnvironmentId());
                }
            }
            return transformBuilder.build();
        }
    }

    private static class RawPTransformTranslator
    implements TransformTranslator<RawPTransform<?, ?>> {
        private RawPTransformTranslator() {
        }

        @Override
        public String getUrn(RawPTransform transform) {
            return transform.getUrn();
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof RawPTransform;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder transformBuilder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            PTransform transform = appliedPTransform.getTransform();
            RunnerApi.FunctionSpec spec = ((RawPTransform)transform).migrate(components);
            if (spec != null) {
                transformBuilder.setSpec(spec);
            }
            transformBuilder.setEnvironmentId(components.getOnlyEnvironmentId());
            return transformBuilder.build();
        }
    }

    private static class DefaultUnknownTransformTranslator
    implements TransformTranslator<PTransform<?, ?>> {
        private static final TransformTranslator<?> INSTANCE = new DefaultUnknownTransformTranslator();

        private DefaultUnknownTransformTranslator() {
        }

        @Override
        public String getUrn(PTransform<?, ?> transform) {
            return null;
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return true;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            return PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components).build();
        }
    }

    public static interface TransformTranslator<T extends PTransform<?, ?>> {
        @Nullable
        public String getUrn(T var1);

        public boolean canTranslate(PTransform<?, ?> var1);

        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> var1, List<AppliedPTransform<?, ?, ?>> var2, SdkComponents var3) throws IOException;
    }
}

