/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CombineTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.Timer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.DoFnWithExecutionInformation;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

public class ParDoTranslation {
    public static final String CUSTOM_JAVA_DO_FN_URN = "beam:dofn:javasdk:0.1";
    public static final String CUSTOM_JAVA_VIEW_FN_URN = "beam:viewfn:javasdk:0.1";
    public static final String CUSTOM_JAVA_WINDOW_MAPPING_FN_URN = "beam:windowmappingfn:javasdk:0.1";

    public static RunnerApi.ParDoPayload translateParDo(AppliedPTransform<?, ?, ParDo.MultiOutput<?, ?>> appliedPTransform, SdkComponents components) throws IOException {
        ParDo.MultiOutput parDo = (ParDo.MultiOutput)appliedPTransform.getTransform();
        Pipeline pipeline = appliedPTransform.getPipeline();
        DoFn doFn = parDo.getFn();
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        Set allInputs = appliedPTransform.getInputs().keySet().stream().map(TupleTag::getId).collect(Collectors.toSet());
        Set sideInputs = parDo.getSideInputs().values().stream().map(s -> s.getTagInternal().getId()).collect(Collectors.toSet());
        Set timerInputs = signature.timerDeclarations().keySet();
        String mainInputName = (String)Iterables.getOnlyElement((Iterable)Sets.difference(allInputs, (Set)Sets.union(sideInputs, timerInputs)));
        PCollection mainInput = (PCollection)appliedPTransform.getInputs().get(new TupleTag(mainInputName));
        DoFnSchemaInformation doFnSchemaInformation = ParDo.getDoFnSchemaInformation((DoFn)doFn, (PCollection)mainInput);
        return ParDoTranslation.translateParDo(parDo, doFnSchemaInformation, pipeline, components);
    }

    public static RunnerApi.ParDoPayload translateParDo(final ParDo.MultiOutput<?, ?> parDo, final DoFnSchemaInformation doFnSchemaInformation, Pipeline pipeline, SdkComponents components) throws IOException {
        String restrictionCoderId;
        final DoFn doFn = parDo.getFn();
        final DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.processElement().isSplittable()) {
            Coder restrictionCoder = DoFnInvokers.invokerFor((DoFn)doFn).invokeGetRestrictionCoder(pipeline.getCoderRegistry());
            restrictionCoderId = components.registerCoder(restrictionCoder);
        } else {
            restrictionCoderId = "";
        }
        return ParDoTranslation.payloadForParDoLike(new ParDoLike(){

            @Override
            public RunnerApi.FunctionSpec translateDoFn(SdkComponents newComponents) {
                return ParDoTranslation.translateDoFn(parDo.getFn(), parDo.getMainOutputTag(), parDo.getSideInputs(), doFnSchemaInformation, newComponents);
            }

            @Override
            public List<RunnerApi.Parameter> translateParameters() {
                return ParDoTranslation.translateParameters(signature.processElement().extraParameters());
            }

            @Override
            public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView sideInput : parDo.getSideInputs().values()) {
                    sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
                }
                return sideInputs;
            }

            @Override
            public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components) throws IOException {
                HashMap<String, RunnerApi.StateSpec> stateSpecs = new HashMap<String, RunnerApi.StateSpec>();
                for (Map.Entry state : signature.stateDeclarations().entrySet()) {
                    RunnerApi.StateSpec spec = ParDoTranslation.translateStateSpec(DoFnSignatures.getStateSpecOrThrow((DoFnSignature.StateDeclaration)((DoFnSignature.StateDeclaration)state.getValue()), (DoFn)doFn), components);
                    stateSpecs.put((String)state.getKey(), spec);
                }
                return stateSpecs;
            }

            @Override
            public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents newComponents) {
                HashMap<String, RunnerApi.TimerSpec> timerSpecs = new HashMap<String, RunnerApi.TimerSpec>();
                for (Map.Entry timer : signature.timerDeclarations().entrySet()) {
                    RunnerApi.TimerSpec spec = ParDoTranslation.translateTimerSpec(DoFnSignatures.getTimerSpecOrThrow((DoFnSignature.TimerDeclaration)((DoFnSignature.TimerDeclaration)timer.getValue()), (DoFn)doFn), newComponents);
                    timerSpecs.put((String)timer.getKey(), spec);
                }
                return timerSpecs;
            }

            @Override
            public Map<String, RunnerApi.TimerFamilySpec> translateTimerFamilySpecs(SdkComponents newComponents) {
                HashMap<String, RunnerApi.TimerFamilySpec> timerFamilySpecs = new HashMap<String, RunnerApi.TimerFamilySpec>();
                for (Map.Entry timerFamily : signature.timerFamilyDeclarations().entrySet()) {
                    RunnerApi.TimerFamilySpec spec = ParDoTranslation.translateTimerFamilySpec(DoFnSignatures.getTimerFamilySpecOrThrow((DoFnSignature.TimerFamilyDeclaration)((DoFnSignature.TimerFamilyDeclaration)timerFamily.getValue()), (DoFn)doFn), newComponents);
                    timerFamilySpecs.put((String)timerFamily.getKey(), spec);
                }
                return timerFamilySpecs;
            }

            @Override
            public boolean isSplittable() {
                return signature.processElement().isSplittable();
            }

            @Override
            public boolean isRequiresTimeSortedInput() {
                return signature.processElement().requiresTimeSortedInput();
            }

            @Override
            public boolean requestsFinalization() {
                return signature.startBundle() != null && signature.startBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.processElement() != null && signature.processElement().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.finishBundle() != null && signature.finishBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer());
            }

            @Override
            public String translateRestrictionCoderId(SdkComponents newComponents) {
                return restrictionCoderId;
            }
        }, components);
    }

    public static List<RunnerApi.Parameter> translateParameters(List<DoFnSignature.Parameter> params) {
        ArrayList<RunnerApi.Parameter> parameters = new ArrayList<RunnerApi.Parameter>();
        for (DoFnSignature.Parameter parameter : params) {
            RunnerApi.Parameter protoParameter = ParDoTranslation.translateParameter(parameter);
            if (protoParameter == null) continue;
            parameters.add(protoParameter);
        }
        return parameters;
    }

    public static DoFn<?, ?> getDoFn(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getDoFn();
    }

    public static DoFn<?, ?> getDoFn(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getFn();
        }
        return ParDoTranslation.getDoFn(ParDoTranslation.getParDoPayload(application));
    }

    public static DoFnSchemaInformation getSchemaInformation(AppliedPTransform<?, ?, ?> application) {
        try {
            return ParDoTranslation.getSchemaInformation(ParDoTranslation.getParDoPayload(application));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DoFnSchemaInformation getSchemaInformation(RunnerApi.PTransform pTransform) {
        try {
            return ParDoTranslation.getSchemaInformation(ParDoTranslation.getParDoPayload(pTransform));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DoFnSchemaInformation getSchemaInformation(RunnerApi.ParDoPayload payload) {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getSchemaInformation();
    }

    public static TupleTag<?> getMainOutputTag(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getMainOutputTag();
    }

    public static Map<String, PCollectionView<?>> getSideInputMapping(AppliedPTransform<?, ?, ?> application) {
        try {
            return ParDoTranslation.getSideInputMapping(ParDoTranslation.getParDoPayload(application));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, PCollectionView<?>> getSideInputMapping(RunnerApi.PTransform pTransform) {
        try {
            return ParDoTranslation.getSideInputMapping(ParDoTranslation.getParDoPayload(pTransform));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, PCollectionView<?>> getSideInputMapping(RunnerApi.ParDoPayload payload) {
        return ParDoTranslation.doFnWithExecutionInformationFromProto(payload.getDoFn()).getSideInputMapping();
    }

    public static TupleTag<?> getMainOutputTag(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getMainOutputTag();
        }
        return ParDoTranslation.getMainOutputTag(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTagList getAdditionalOutputTags(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getAdditionalOutputTags();
        }
        RunnerApi.PTransform protoTransform = PTransformTranslation.toProto(application, SdkComponents.create(application.getPipeline().getOptions()));
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)protoTransform.getSpec().getPayload());
        TupleTag<?> mainOutputTag = ParDoTranslation.getMainOutputTag(payload);
        Sets.SetView outputTags = Sets.difference(protoTransform.getOutputsMap().keySet(), Collections.singleton(mainOutputTag.getId()));
        ArrayList<TupleTag> additionalOutputTags = new ArrayList<TupleTag>();
        for (String outputTag : outputTags) {
            additionalOutputTags.add(new TupleTag(outputTag));
        }
        return TupleTagList.of(additionalOutputTags);
    }

    public static Map<TupleTag<?>, Coder<?>> getOutputCoders(AppliedPTransform<?, ?, ?> application) {
        return application.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    public static List<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getSideInputs().values().stream().collect(Collectors.toList());
        }
        SdkComponents sdkComponents = SdkComponents.create(application.getPipeline().getOptions());
        RunnerApi.PTransform parDoProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDoProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = (String)sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = (RunnerApi.SideInput)sideInputEntry.getValue();
            PCollection originalPCollection = (PCollection)Preconditions.checkNotNull((Object)((PCollection)application.getInputs().get(new TupleTag(sideInputTag))), (String)"no input with tag %s", (Object)sideInputTag);
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, parDoProto, components));
        }
        return views;
    }

    public static RunnerApi.PCollection getMainInput(RunnerApi.PTransform ptransform, RunnerApi.Components components) throws IOException {
        Preconditions.checkArgument(("beam:transform:pardo:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_elements:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(ptransform.getSpec().getUrn()) ? 1 : 0) != 0, (String)"Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        return components.getPcollectionsOrThrow(ptransform.getInputsOrThrow(ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)ptransform)));
    }

    public static String getMainInputName(RunnerApi.PTransformOrBuilder ptransform) throws IOException {
        Preconditions.checkArgument(("beam:transform:pardo:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_pair_with_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_restriction:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_split_and_size_restrictions:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_elements:v1".equals(ptransform.getSpec().getUrn()) || "beam:transform:sdf_process_sized_element_and_restrictions:v1".equals(ptransform.getSpec().getUrn()) ? 1 : 0) != 0, (String)"Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)ptransform.getSpec().getPayload());
        return ParDoTranslation.getMainInputName(ptransform, payload);
    }

    private static String getMainInputName(RunnerApi.PTransformOrBuilder ptransform, RunnerApi.ParDoPayload payload) {
        return (String)Iterables.getOnlyElement((Iterable)Sets.difference(ptransform.getInputsMap().keySet(), (Set)Sets.union(payload.getSideInputsMap().keySet(), payload.getTimerSpecsMap().keySet())));
    }

    public static RunnerApi.StateSpec translateStateSpec(StateSpec<?> stateSpec, final SdkComponents components) throws IOException {
        final RunnerApi.StateSpec.Builder builder = RunnerApi.StateSpec.newBuilder();
        return (RunnerApi.StateSpec)stateSpec.match((StateSpec.Cases)new StateSpec.Cases<RunnerApi.StateSpec>(){

            public RunnerApi.StateSpec dispatchValue(Coder<?> valueCoder) {
                return builder.setReadModifyWriteSpec(RunnerApi.ReadModifyWriteStateSpec.newBuilder().setCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchBag(Coder<?> elementCoder) {
                return builder.setBagSpec(RunnerApi.BagStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }

            public RunnerApi.StateSpec dispatchCombining(Combine.CombineFn<?, ?, ?> combineFn, Coder<?> accumCoder) {
                return builder.setCombiningSpec(RunnerApi.CombiningStateSpec.newBuilder().setAccumulatorCoderId(ParDoTranslation.registerCoderOrThrow(components, accumCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components))).build();
            }

            public RunnerApi.StateSpec dispatchMap(Coder<?> keyCoder, Coder<?> valueCoder) {
                return builder.setMapSpec(RunnerApi.MapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchSet(Coder<?> elementCoder) {
                return builder.setSetSpec(RunnerApi.SetStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }
        });
    }

    @VisibleForTesting
    static StateSpec<?> fromProto(RunnerApi.StateSpec stateSpec, RehydratedComponents components) throws IOException {
        switch (stateSpec.getSpecCase()) {
            case READ_MODIFY_WRITE_SPEC: {
                return StateSpecs.value(components.getCoder(stateSpec.getReadModifyWriteSpec().getCoderId()));
            }
            case BAG_SPEC: {
                return StateSpecs.bag(components.getCoder(stateSpec.getBagSpec().getElementCoderId()));
            }
            case COMBINING_SPEC: {
                RunnerApi.FunctionSpec combineFnSpec = stateSpec.getCombiningSpec().getCombineFn();
                if (!combineFnSpec.getUrn().equals("beam:combinefn:javasdk:v1")) {
                    throw new UnsupportedOperationException(String.format("Cannot create %s from non-Java %s: %s", StateSpec.class.getSimpleName(), Combine.CombineFn.class.getSimpleName(), combineFnSpec.getUrn()));
                }
                Combine.CombineFn combineFn = (Combine.CombineFn)SerializableUtils.deserializeFromByteArray((byte[])combineFnSpec.getPayload().toByteArray(), (String)Combine.CombineFn.class.getSimpleName());
                return StateSpecs.combining(components.getCoder(stateSpec.getCombiningSpec().getAccumulatorCoderId()), (Combine.CombineFn)combineFn);
            }
            case MAP_SPEC: {
                return StateSpecs.map(components.getCoder(stateSpec.getMapSpec().getKeyCoderId()), components.getCoder(stateSpec.getMapSpec().getValueCoderId()));
            }
            case SET_SPEC: {
                return StateSpecs.set(components.getCoder(stateSpec.getSetSpec().getElementCoderId()));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", RunnerApi.StateSpec.class.getName(), stateSpec));
    }

    private static String registerCoderOrThrow(SdkComponents components, Coder coder) {
        try {
            return components.registerCoder(coder);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failure to register coder", exc);
        }
    }

    public static RunnerApi.TimerSpec translateTimerSpec(TimerSpec timer, SdkComponents components) {
        return RunnerApi.TimerSpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(timer.getTimeDomain())).setTimerCoderId(ParDoTranslation.registerCoderOrThrow(components, (Coder)Timer.Coder.of(VoidCoder.of()))).build();
    }

    public static RunnerApi.TimerFamilySpec translateTimerFamilySpec(TimerSpec timer, SdkComponents components) {
        return RunnerApi.TimerFamilySpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(timer.getTimeDomain())).setTimerFamilyCoderId(ParDoTranslation.registerCoderOrThrow(components, (Coder)Timer.Coder.of(VoidCoder.of()))).build();
    }

    private static RunnerApi.TimeDomain.Enum translateTimeDomain(TimeDomain timeDomain) {
        switch (timeDomain) {
            case EVENT_TIME: {
                return RunnerApi.TimeDomain.Enum.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.PROCESSING_TIME;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.SYNCHRONIZED_PROCESSING_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    public static RunnerApi.FunctionSpec translateDoFn(DoFn<?, ?> fn, TupleTag<?> tag, Map<String, PCollectionView<?>> sideInputMapping, DoFnSchemaInformation doFnSchemaInformation, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_DO_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)DoFnWithExecutionInformation.of(fn, tag, sideInputMapping, (DoFnSchemaInformation)doFnSchemaInformation)))).build();
    }

    public static DoFnWithExecutionInformation doFnWithExecutionInformationFromProto(RunnerApi.FunctionSpec fnSpec) {
        Preconditions.checkArgument((boolean)fnSpec.getUrn().equals(CUSTOM_JAVA_DO_FN_URN), (String)"Expected %s to be %s with URN %s, but URN was %s", (Object)DoFn.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)CUSTOM_JAVA_DO_FN_URN, (Object)fnSpec.getUrn());
        byte[] serializedFn = fnSpec.getPayload().toByteArray();
        return (DoFnWithExecutionInformation)SerializableUtils.deserializeFromByteArray((byte[])serializedFn, (String)"Custom DoFn With Execution Info");
    }

    @Nullable
    public static RunnerApi.Parameter translateParameter(DoFnSignature.Parameter parameter) {
        return (RunnerApi.Parameter)parameter.match((DoFnSignature.Parameter.Cases)new DoFnSignature.Parameter.Cases.WithDefault<RunnerApi.Parameter>(){

            public RunnerApi.Parameter dispatch(DoFnSignature.Parameter.WindowParameter p) {
                return RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.WINDOW).build();
            }

            public RunnerApi.Parameter dispatch(DoFnSignature.Parameter.RestrictionTrackerParameter p) {
                return RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.RESTRICTION_TRACKER).build();
            }

            @Nullable
            protected RunnerApi.Parameter dispatchDefault(DoFnSignature.Parameter p) {
                return null;
            }
        });
    }

    public static Map<String, RunnerApi.SideInput> translateSideInputs(List<PCollectionView<?>> views, SdkComponents components) {
        HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
        for (PCollectionView<?> sideInput : views) {
            sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
        }
        return sideInputs;
    }

    public static RunnerApi.SideInput translateView(PCollectionView<?> view, SdkComponents components) {
        RunnerApi.SideInput.Builder builder = RunnerApi.SideInput.newBuilder();
        builder.setAccessPattern(RunnerApi.FunctionSpec.newBuilder().setUrn(view.getViewFn().getMaterialization().getUrn()).build());
        builder.setViewFn(ParDoTranslation.translateViewFn(view.getViewFn(), components));
        builder.setWindowMappingFn(ParDoTranslation.translateWindowMappingFn(view.getWindowMappingFn(), components));
        return builder.build();
    }

    public static RunnerApi.FunctionSpec translateViewFn(ViewFn<?, ?> viewFn, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_VIEW_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(viewFn))).build();
    }

    private static <T> RunnerApi.ParDoPayload getParDoPayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        RunnerApi.PTransform parDoPTransform = PTransformTranslation.toProto(transform, Collections.emptyList(), components);
        return ParDoTranslation.getParDoPayload(parDoPTransform);
    }

    private static RunnerApi.ParDoPayload getParDoPayload(RunnerApi.PTransform parDoPTransform) throws IOException {
        return RunnerApi.ParDoPayload.parseFrom((ByteString)parDoPTransform.getSpec().getPayload());
    }

    public static boolean usesStateOrTimers(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getStateSpecsCount() > 0 || payload.getTimerSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0;
    }

    public static boolean isSplittable(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getSplittable();
    }

    public static RunnerApi.FunctionSpec translateWindowMappingFn(WindowMappingFn<?> windowMappingFn, SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(windowMappingFn))).build();
    }

    public static RunnerApi.ParDoPayload payloadForParDoLike(ParDoLike parDo, SdkComponents components) throws IOException {
        return RunnerApi.ParDoPayload.newBuilder().setDoFn(parDo.translateDoFn(components)).addAllParameters(parDo.translateParameters()).putAllStateSpecs(parDo.translateStateSpecs(components)).putAllTimerSpecs(parDo.translateTimerSpecs(components)).putAllTimerFamilySpecs(parDo.translateTimerFamilySpecs(components)).putAllSideInputs(parDo.translateSideInputs(components)).setSplittable(parDo.isSplittable()).setRequiresTimeSortedInput(parDo.isRequiresTimeSortedInput()).setRestrictionCoderId(parDo.translateRestrictionCoderId(components)).setRequestsFinalization(parDo.requestsFinalization()).build();
    }

    public static interface ParDoLike {
        public RunnerApi.FunctionSpec translateDoFn(SdkComponents var1);

        public List<RunnerApi.Parameter> translateParameters();

        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents var1);

        public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents var1) throws IOException;

        public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents var1);

        public Map<String, RunnerApi.TimerFamilySpec> translateTimerFamilySpecs(SdkComponents var1);

        public boolean isSplittable();

        public boolean isRequiresTimeSortedInput();

        public boolean requestsFinalization();

        public String translateRestrictionCoderId(SdkComponents var1);
    }

    public static class ParDoTranslator
    implements PTransformTranslation.TransformTranslator<ParDo.MultiOutput<?, ?>> {
        public static PTransformTranslation.TransformTranslator create() {
            return new ParDoTranslator();
        }

        private ParDoTranslator() {
        }

        @Override
        public String getUrn(ParDo.MultiOutput<?, ?> transform) {
            return "beam:transform:pardo:v1";
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof ParDo.MultiOutput;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder builder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            AppliedPTransform<?, ?, ?> appliedParDo = appliedPTransform;
            RunnerApi.ParDoPayload payload = ParDoTranslation.translateParDo(appliedParDo, components);
            builder.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:pardo:v1").setPayload(payload.toByteString()).build());
            builder.setEnvironmentId(components.getOnlyEnvironmentId());
            String mainInputName = ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)builder, payload);
            PCollection mainInput = (PCollection)appliedPTransform.getInputs().get(new TupleTag(mainInputName));
            for (String localTimerName : payload.getTimerSpecsMap().keySet()) {
                PCollection timerPCollection = PCollection.createPrimitiveOutputInternal((Pipeline)Pipeline.create(), (WindowingStrategy)mainInput.getWindowingStrategy(), (PCollection.IsBounded)mainInput.isBounded(), (Coder)KvCoder.of((Coder)((KvCoder)mainInput.getCoder()).getKeyCoder(), (Coder)Timer.Coder.of(VoidCoder.of())));
                timerPCollection.setName(String.format("%s.%s", appliedPTransform.getFullName(), localTimerName));
                String timerPCollectionId = components.registerPCollection(timerPCollection);
                builder.putInputs(localTimerName, timerPCollectionId);
                builder.putOutputs(localTimerName, timerPCollectionId);
            }
            return builder.build();
        }
    }
}

