/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Equivalence;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;

public abstract class StateTable {
    private final Table<StateNamespace, Equivalence.Wrapper<StateTag>, State> stateTable = HashBasedTable.create();

    public <StateT extends State> StateT get(StateNamespace namespace, StateTag<StateT> tag, StateContext<?> c) {
        Equivalence.Wrapper tagById = StateTags.ID_EQUIVALENCE.wrap(tag);
        State storage = this.getOrNull(namespace, (Equivalence.Wrapper<StateTag>)tagById, c);
        if (storage != null) {
            State typedStorage = storage;
            return (StateT)typedStorage;
        }
        StateT typedStorage = tag.bind(this.binderForNamespace(namespace, c));
        this.stateTable.put((Object)namespace, (Object)tagById, typedStorage);
        return typedStorage;
    }

    @Nullable
    public State getOrNull(StateNamespace namespace, Equivalence.Wrapper<StateTag> tag, StateContext<?> c) {
        return (State)this.stateTable.get((Object)namespace, tag);
    }

    public void clearNamespace(StateNamespace namespace) {
        this.stateTable.rowKeySet().remove(namespace);
    }

    public void clear() {
        this.stateTable.clear();
    }

    public Iterable<State> values() {
        return this.stateTable.values();
    }

    public boolean isNamespaceInUse(StateNamespace namespace) {
        return this.stateTable.containsRow((Object)namespace);
    }

    public Map<StateTag, State> getTagsInUse(StateNamespace namespace) {
        Map row = this.stateTable.row((Object)namespace);
        HashMap<StateTag, State> result = new HashMap<StateTag, State>();
        for (Map.Entry entry : row.entrySet()) {
            result.put((StateTag)((Equivalence.Wrapper)entry.getKey()).get(), (State)entry.getValue());
        }
        return result;
    }

    public Set<StateNamespace> getNamespacesInUse() {
        return this.stateTable.rowKeySet();
    }

    protected abstract StateTag.StateBinder binderForNamespace(StateNamespace var1, StateContext<?> var2);
}

